/*
 * Decompiled with CFR 0.152.
 */
package fun.tusi.utils;

import java.lang.reflect.Field;
import java.util.Arrays;

public class EnumUtils {
    public static <E extends Enum<E>, T> boolean isValidEnumValue(Class<E> enumClass, String fieldName, T value) {
        try {
            Field field = enumClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                Object fieldValue = field.get(enumValue);
                if (!fieldValue.equals(value)) continue;
                return true;
            }
            return false;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
    }

    public static <E extends Enum<E>> boolean anyMatch(Class<E> enumClass, String name) {
        return Arrays.asList((Enum[])enumClass.getEnumConstants()).stream().anyMatch(o -> o.name().equals(name));
    }
}

