/*
 * Decompiled with CFR 0.152.
 */
package fun.tusi.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import fun.tusi.utils.StringUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class JsonUtils {
    private static final ObjectMapper OM = new ObjectMapper();

    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : OM.writeValueAsString(obj);
        }
        catch (JsonProcessingException var2) {
            var2.printStackTrace();
            return null;
        }
    }

    public static String toPrettyJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : OM.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (Exception var2) {
            var2.printStackTrace();
            return null;
        }
    }

    public static <T> T toBean(String jsonStr, Class<T> clazz) {
        if (StringUtils.hasText(jsonStr) && clazz != null) {
            try {
                return (T)(clazz.equals(String.class) ? jsonStr : OM.readValue(jsonStr, clazz));
            }
            catch (IOException var3) {
                var3.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static <T> List<T> toList(String jsonStr, Class<T> clazz) {
        if (StringUtils.hasText(jsonStr) && clazz != null) {
            JavaType javaType = OM.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clazz});
            try {
                return (List)OM.readValue(jsonStr, javaType);
            }
            catch (IOException var4) {
                var4.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static <T> T toBean4TypeReference(String jsonStr, TypeReference<T> typeReference) {
        if (StringUtils.hasText(jsonStr) && typeReference != null) {
            try {
                return (T)OM.readValue(jsonStr, typeReference);
            }
            catch (IOException var3) {
                var3.printStackTrace();
                return null;
            }
        }
        return null;
    }

    static {
        OM.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OM.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        OM.registerModule((Module)javaTimeModule);
    }
}

