/*
 * Decompiled with CFR 0.152.
 */
package fun.tusi.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TreeUtils<T> {
    private Function<T, Object> parent;
    private Function<T, Object> code;
    private Function<T, List<T>> children;

    public TreeUtils<T> parent(Function<T, Object> parent) {
        this.parent = parent;
        return this;
    }

    public TreeUtils<T> code(Function<T, Object> code) {
        this.code = code;
        return this;
    }

    public TreeUtils<T> children(Function<T, List<T>> children) {
        this.children = children;
        return this;
    }

    public List<T> tree(List<T> sourceList) {
        ArrayList treeList = new ArrayList();
        Map<Object, Object> codeMap = sourceList.stream().collect(Collectors.toMap(t -> this.code.apply(t), t -> t));
        sourceList.stream().forEach(t -> {
            if (!codeMap.containsKey(this.parent.apply(t))) {
                treeList.add(t);
            } else {
                Object parentT = codeMap.get(this.parent.apply(t));
                this.children.apply(parentT).add(t);
            }
        });
        return treeList;
    }

    public List<T> tree(List<T> sourceList, Object pid) {
        ArrayList treeList = new ArrayList();
        Map<Object, Object> codeMap = sourceList.stream().collect(Collectors.toMap(t -> this.code.apply(t), t -> t));
        sourceList.stream().forEach(t -> {
            if (Objects.equals(pid, this.parent.apply(t))) {
                treeList.add(t);
            } else {
                Object parentT = codeMap.get(this.parent.apply(t));
                if (Objects.nonNull(parentT)) {
                    this.children.apply(parentT).add(t);
                }
            }
        });
        return treeList;
    }
}

