/*
 * Decompiled with CFR 0.152.
 */
package com.demo.ecom.app.web.user.controller;

import com.demo.ecom.app.web.user.form.LoginForm;
import com.demo.ecom.core.exception.AuthenticationException;
import com.demo.ecom.core.model.entity.Account;
import com.demo.ecom.core.service.AccountService;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/login"})
public class LoginController {
    public static final String ACCOUNT_ATTRIBUTE = "account";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private AccountService accountService;

    @RequestMapping(method={RequestMethod.GET})
    public String login(Model uiModel) {
        uiModel.addAttribute("loginForm", (Object)new LoginForm());
        return "login";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String handleLogin(@Valid LoginForm loginForm, HttpSession session, RedirectAttributes redirectAttributes) {
        try {
            LOGGER.info("LoginForm: {}", (Object)loginForm.toString());
            Account account = this.accountService.login(loginForm.getUsername(), loginForm.getPassword());
            session.setAttribute(ACCOUNT_ATTRIBUTE, (Object)account);
            return "redirect:/index";
        }
        catch (AuthenticationException e) {
            redirectAttributes.addFlashAttribute("exception", (Object)e);
            return "redirect:/login";
        }
    }
}

