<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<c:url value="/resources/images/books/${item.isbn}/book_front_cover.png" var="itemImage" />
<img src="${itemImage}" align="left" alt="${item.title}" width="250" />

<table>
	<tr>
		<td><spring:message code="book.detail.title"/></td>
		<td>${item.title}</td>
	</tr>
	<tr>
		<td><spring:message code="book.detail.description"/></td>
		<td>${item.description}</td>
	</tr>
	<tr>
		<td><spring:message code="book.detail.author"/></td>
		<td>${item.author}</td>
	</tr>
	<tr>
		<td><spring:message code="book.detail.year"/></td>
		<td>${item.year}</td>
	</tr>
	<tr>
		<td><spring:message code="book.detail.isbn"/></td>
		<td>${item.isbn}</td>
	</tr>
	<tr>
		<td><spring:message code="book.detail.price"/></td>
		<td>${item.price}</td>
	</tr>
</table>