/*
 * Decompiled with CFR 0.152.
 */
package ga.rugal.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitWalker {
    private final Log log;
    private final String gitFolder;
    private final String head;
    private final String matchPattern;
    private final String testCommitMessage;

    public String getRecentCommitMessage() throws IOException, RevisionSyntaxException {
        try {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            builder.setGitDir(new File(this.gitFolder));
            Repository repository = builder.build();
            RevWalk walk = new RevWalk(repository);
            RevCommit commit = walk.parseCommit((AnyObjectId)repository.resolve(this.head));
            String commitMessage = commit.getShortMessage();
            walk.dispose();
            this.log.debug((CharSequence)String.format("Find commit message from git [%s]", commitMessage));
            return commitMessage;
        }
        catch (IOException | NullPointerException | RevisionSyntaxException e) {
            this.log.error((CharSequence)"Unable to open .git directory");
            throw e;
        }
    }

    public String extractContent(String capturedString) throws MojoFailureException {
        Pattern pattern = Pattern.compile("[\\w\\d\\s-_]+");
        Matcher matcher = pattern.matcher(capturedString);
        if (!matcher.find()) {
            throw new MojoFailureException(String.format("No content found [%s]", capturedString));
        }
        return matcher.group().trim();
    }

    public Matcher patternMatcher() throws RevisionSyntaxException, IOException {
        String commitMessage = this.getRecentCommitMessage();
        if (null != this.testCommitMessage) {
            commitMessage = this.testCommitMessage;
            this.log.debug((CharSequence)String.format("Use test commit message [%s]", this.testCommitMessage));
        }
        Pattern pattern = Pattern.compile(this.matchPattern);
        return pattern.matcher(commitMessage);
    }

    public GitWalker(Log log, String gitFolder, String head, String matchPattern, String testCommitMessage) {
        this.log = log;
        this.gitFolder = gitFolder;
        this.head = head;
        this.matchPattern = matchPattern;
        this.testCommitMessage = testCommitMessage;
    }
}

