/*
 * Decompiled with CFR 0.152.
 */
package ga.rugal.maven.plugin;

import ga.rugal.maven.plugin.CaptureGroup;
import ga.rugal.maven.plugin.GitWalker;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.errors.RevisionSyntaxException;

@Mojo(name="show")
public class MessageShowMojo
extends AbstractMojo {
    @Parameter
    private boolean skip = false;
    @Parameter
    private String gitFolder = ".git";
    @Parameter
    private String head = "HEAD";
    @Parameter
    private boolean failOnError = false;
    @Parameter
    private String testCommitMessage;
    @Parameter
    private String matchPattern = "(.*)";
    @Parameter
    private CaptureGroup[] captureGroups = new CaptureGroup[0];

    private void readSystemProperty() {
        String skipProperty = System.getProperty("commitlinter.skip");
        this.skip = null != skipProperty ? Boolean.parseBoolean(skipProperty) : this.skip;
        String failOnErrorProperty = System.getProperty("commitlinter.failOnError");
        this.failOnError = null != failOnErrorProperty ? Boolean.parseBoolean(failOnErrorProperty) : this.failOnError;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.readSystemProperty();
        Log log = this.getLog();
        GitWalker walker = new GitWalker(this.getLog(), this.gitFolder, this.head, this.matchPattern, this.testCommitMessage);
        try {
            String string = String.format("%n%-20s:[%b]%n%-20s:[%b]%n%-20s:[%s]%n%-20s:[%s]%n%-20s:[%s]%n%-20s:[%s]%n%-20s:[%s]%n", "skip", this.skip, "failOnError", this.failOnError, "gitFolder", this.gitFolder, "head", this.head, "testCommitMessage", this.testCommitMessage, "matchPattern", this.matchPattern, "CommitMessage", walker.getRecentCommitMessage());
            log.info((CharSequence)"Basic Configuration");
            log.info((CharSequence)string);
            log.info((CharSequence)"Capture Group Definition:");
            for (CaptureGroup group : this.captureGroups) {
                log.info((CharSequence)String.format("%n%-15s:[%s]%n%-15s:[%s]%n%-15s:[%d]%n%-15s:[%d]%n", new Object[]{"CaseFormat", group.getCaseFormat(), "Tense", group.getTense(), "MinimunLength", group.getMin(), "MaximumLength", group.getMax()}));
            }
        }
        catch (IOException | NullPointerException | RevisionSyntaxException ex) {
            throw new MojoFailureException("Unable to lint commit message due to git repository error");
        }
    }
}

