/*
 * Decompiled with CFR 0.152.
 */
package ga.rugal.maven.plugin;

import ga.rugal.maven.plugin.CaptureGroup;
import ga.rugal.maven.plugin.GitWalker;
import ga.rugal.maven.plugin.RuleChecker;
import java.io.IOException;
import java.util.regex.Matcher;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.errors.RevisionSyntaxException;

@Mojo(name="validate")
public class MessageValidatorMojo
extends AbstractMojo {
    @Parameter
    private boolean skip = false;
    @Parameter
    private String gitFolder = ".git";
    @Parameter
    private String head = "HEAD";
    @Parameter
    private boolean failOnError = false;
    @Parameter
    private String testCommitMessage;
    @Parameter
    private String matchPattern = "(.*)";
    @Parameter
    private CaptureGroup[] captureGroups = new CaptureGroup[0];

    private void readSystemProperty() {
        String skipProperty = System.getProperty("commitlinter.skip");
        this.skip = null != skipProperty ? Boolean.parseBoolean(skipProperty) : this.skip;
        String failOnErrorProperty = System.getProperty("commitlinter.failOnError");
        this.failOnError = null != failOnErrorProperty ? Boolean.parseBoolean(failOnErrorProperty) : this.failOnError;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.readSystemProperty();
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip Commitlinter");
            return;
        }
        try {
            GitWalker walker = new GitWalker(this.getLog(), this.gitFolder, this.head, this.matchPattern, this.testCommitMessage);
            Matcher matcher = walker.patternMatcher();
            if (!matcher.find()) {
                throw new MojoFailureException(String.format("No pattern matched by Regex: [%s]", this.matchPattern));
            }
            int result = 0;
            for (int i = 1; i <= Math.min(this.captureGroups.length, matcher.groupCount()); ++i) {
                String extractedContent = walker.extractContent(matcher.group(i));
                this.getLog().debug((CharSequence)extractedContent);
                RuleChecker checker = new RuleChecker(this.captureGroups[i - 1], this.getLog());
                result += checker.check(extractedContent);
            }
            if (0 == result) {
                return;
            }
            if (this.failOnError) {
                throw new MojoFailureException("Commit Lint failed, please check rules");
            }
        }
        catch (IOException | NullPointerException | RevisionSyntaxException ex) {
            throw new MojoFailureException("Unable to lint commit message due to git repository error");
        }
    }
}

