/*
 * Decompiled with CFR 0.152.
 */
package ga.rugal.maven.plugin;

import ga.rugal.maven.plugin.CaptureGroup;
import ga.rugal.maven.plugin.rule.CaseRule;
import ga.rugal.maven.plugin.rule.LengthRule;
import ga.rugal.maven.plugin.rule.TenseRule;
import org.apache.maven.plugin.logging.Log;

public class RuleChecker {
    private final CaptureGroup captureGroup;
    private final Log log;

    public int check(String match) {
        int failed = 0;
        this.log.info((CharSequence)String.format("Linting: [%s]", match));
        if (!CaseRule.validate(match, this.captureGroup.getCaseFormat())) {
            this.log.error((CharSequence)String.format("    Case format should be %s", this.captureGroup.getCaseFormat().name()));
            ++failed;
        }
        if (!TenseRule.validate(match, this.captureGroup.getTense())) {
            this.log.error((CharSequence)String.format("    Tense of initial word should be %s", this.captureGroup.getTense().name()));
            ++failed;
        }
        if (!LengthRule.fitMax(match, this.captureGroup.getMax())) {
            this.log.error((CharSequence)String.format("    Length should be no more than %d", this.captureGroup.getMax()));
            ++failed;
        }
        if (!LengthRule.fitMin(match, this.captureGroup.getMin())) {
            this.log.error((CharSequence)String.format("    Length should be no less than %d", this.captureGroup.getMin()));
            ++failed;
        }
        return failed;
    }

    public RuleChecker(CaptureGroup captureGroup, Log log) {
        this.captureGroup = captureGroup;
        this.log = log;
    }
}

