/*
 * Decompiled with CFR 0.152.
 */
package ga.rugal.maven.plugin.rule;

import ga.rugal.maven.plugin.rule.Kase;
import java.util.Locale;

public class CaseRule {
    private CaseRule() {
    }

    public static boolean validate(String text, Kase pattern) {
        boolean result;
        switch (pattern) {
            case LOWERCASE: {
                result = CaseRule.isLowerCase(text);
                break;
            }
            case UPPERCASE: {
                result = CaseRule.isUpperCase(text);
                break;
            }
            case UPPERCAMELCASE: {
                result = CaseRule.isUpperCamelCase(text);
                break;
            }
            case LOWERCAMELCASE: {
                result = CaseRule.isLowerCamelCase(text);
                break;
            }
            case KEBABCASE: {
                result = CaseRule.isKebabCase(text);
                break;
            }
            case SNAKECASE: {
                result = CaseRule.isSnakeCase(text);
                break;
            }
            case SENTENCECASE: {
                result = CaseRule.isSentenceCase(text);
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    private static boolean isCamelCase(String text) {
        return !text.contains("_") && !text.contains("-") && !text.contains(" ");
    }

    public static boolean isUpperCamelCase(String text) {
        return CaseRule.isCamelCase(text) && Character.isUpperCase(text.charAt(0));
    }

    public static boolean isLowerCamelCase(String text) {
        return CaseRule.isCamelCase(text) && Character.isLowerCase(text.charAt(0));
    }

    public static boolean isUpperCase(String text) {
        return text.toUpperCase(Locale.ENGLISH).equals(text);
    }

    public static boolean isLowerCase(String text) {
        return text.toLowerCase(Locale.ENGLISH).equals(text);
    }

    public static boolean isKebabCase(String text) {
        return text.toLowerCase(Locale.ENGLISH).replaceAll("_", "-").replaceAll(" ", "-").equals(text);
    }

    public static boolean isSentenceCase(String text) {
        return Character.isUpperCase(text.charAt(0)) && CaseRule.isLowerCase(text.substring(1));
    }

    public static boolean isSnakeCase(String text) {
        return text.toLowerCase(Locale.ENGLISH).replace(" ", "_").replace("-", "_").equals(text);
    }
}

