/*
 * Decompiled with CFR 0.152.
 */
package ga.rugal.maven.plugin.rule;

import com.google.common.collect.ImmutableSet;
import edu.stanford.nlp.simple.Sentence;
import ga.rugal.maven.plugin.rule.Tense;
import java.util.Locale;
import java.util.Set;

public class TenseRule {
    private static final Set<String> PAST_TENSE = ImmutableSet.of((Object)"VBN", (Object)"VBD");
    private static final Set<String> THIRD_PARTY_TENSE = ImmutableSet.of((Object)"VBZ");
    private static final Set<String> PRESENT_TENSE = ImmutableSet.of((Object)"VB", (Object)"VBP");

    private TenseRule() {
    }

    private static boolean matchTense(Set<String> pattern, String word) {
        Sentence sent = new Sentence(word);
        String toUpperCase = sent.posTag(0).toUpperCase(Locale.US);
        return pattern.contains(toUpperCase);
    }

    public static boolean isPastTense(String word) {
        return TenseRule.matchTense(PAST_TENSE, word);
    }

    public static boolean isPresentTense(String word) {
        return TenseRule.matchTense(PRESENT_TENSE, word);
    }

    public static boolean isThirdPartyTense(String word) {
        return TenseRule.matchTense(THIRD_PARTY_TENSE, word);
    }

    public static boolean validate(String word, Tense tense) {
        boolean result;
        switch (tense) {
            case PRESENT: {
                result = TenseRule.isPresentTense(word);
                break;
            }
            case PAST: {
                result = TenseRule.isPastTense(word);
                break;
            }
            case THIRD_PARTY: {
                result = TenseRule.isThirdPartyTense(word);
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }
}

