/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaErrorCode;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.util.ConversionUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaCredentialsFactory {
    private static final Logger log = LoggerFactory.getLogger(SagaCredentialsFactory.class);
    private static final String GRANT_TYPE_KEY = "grant_type";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String CLIENT_SECRET_KEY = "client_secret";
    private static final String CLIENT_CREDENTIAL_VALUE = "client_credentials";
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final int HTTP_OK = 200;
    private static SagaCredentialsFactory instance;
    private final URI authUrl;
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final HttpRequest.BodyPublisher bodyPublisher;
    private final AtomicReference<String> accessToken = new AtomicReference();

    private SagaCredentialsFactory(SagaSdkConfig config) {
        this.authUrl = URI.create(config.getAuthUrl());
        this.bodyPublisher = SagaCredentialsFactory.buildClientCredentialsRequestBody(config.getTitleId(), config.getTitleSecret());
        if (config.isAuthenticated()) {
            String token = this.getAccessToken();
            this.accessToken.set(token);
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
            executor.scheduleAtFixedRate(new RefreshToken(), config.getTokenRefresh(), config.getTokenRefresh(), TimeUnit.SECONDS);
        } else {
            this.accessToken.set("");
        }
    }

    static SagaCredentialsFactory getInstance() throws SagaException {
        if (instance == null) {
            log.error("Tried to get uninitialized Credentials Factory instance");
            throw new SagaException(SagaErrorCode.CREDENTIALS_NOT_INITIALIZED);
        }
        return instance;
    }

    static void initialize(SagaSdkConfig config) throws SagaException {
        if (config.isAuthenticated() && instance != null) {
            log.error("Tried to re-initialize Credentials.");
            throw new SagaException(SagaErrorCode.REINITIALIZATION_ATTEMPTED);
        }
        instance = new SagaCredentialsFactory(config);
    }

    private static HttpRequest.BodyPublisher buildClientCredentialsRequestBody(String clientId, String clientSecret) {
        return SagaCredentialsFactory.buildFormDataFromMap(Map.of(GRANT_TYPE_KEY, CLIENT_CREDENTIAL_VALUE, CLIENT_ID_KEY, clientId, CLIENT_SECRET_KEY, clientSecret));
    }

    private static HttpRequest.BodyPublisher buildFormDataFromMap(Map<String, String> data) {
        StringBuilder builder = new StringBuilder();
        data.forEach((key, value) -> {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(URLEncoder.encode(key, StandardCharsets.UTF_8));
            builder.append("=");
            builder.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        });
        return HttpRequest.BodyPublishers.ofString(builder.toString());
    }

    String getToken() {
        return this.accessToken.get();
    }

    private String getAccessToken() {
        HttpRequest request = HttpRequest.newBuilder(this.authUrl).POST(this.bodyPublisher).setHeader("User-Agent", "Java 11 HttpClient Bot").setHeader("Content-Type", "application/x-www-form-urlencoded").build();
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                log.debug("Refreshing Access Token");
                Map<String, Object> map = ConversionUtils.toStringObjectMap(response.body());
                return (String)map.get(ACCESS_TOKEN_KEY);
            }
        }
        catch (SagaException | IOException | InterruptedException e) {
            log.error("Error while trying to retrieve client credentials.", (Throwable)e);
        }
        return "";
    }

    private class RefreshToken
    implements Runnable {
        private RefreshToken() {
        }

        @Override
        public void run() {
            String token = SagaCredentialsFactory.this.getAccessToken();
            SagaCredentialsFactory.this.accessToken.set(token);
        }
    }
}

