/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.AbstractSagaStreamClient;
import games.mythical.saga.sdk.client.model.SagaCurrencyType;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.factory.CommonFactory;
import games.mythical.saga.sdk.proto.api.currencytype.CurrencyTypeProto;
import games.mythical.saga.sdk.proto.api.currencytype.CurrencyTypeServiceGrpc;
import games.mythical.saga.sdk.proto.api.currencytype.CurrencyTypesProto;
import games.mythical.saga.sdk.proto.api.currencytype.GetCurrencyTypeRequest;
import games.mythical.saga.sdk.proto.api.currencytype.GetCurrencyTypesRequest;
import games.mythical.saga.sdk.proto.common.SortOrder;
import games.mythical.saga.sdk.util.ValidateUtil;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaCurrencyTypeClient
extends AbstractSagaStreamClient {
    private static final Logger log = LoggerFactory.getLogger(SagaCurrencyTypeClient.class);
    private CurrencyTypeServiceGrpc.CurrencyTypeServiceBlockingStub serviceBlockingStub;

    public SagaCurrencyTypeClient(SagaSdkConfig config) throws SagaException {
        super(config);
        this.initStub();
    }

    @Override
    void initStub() {
        this.serviceBlockingStub = (CurrencyTypeServiceGrpc.CurrencyTypeServiceBlockingStub)CurrencyTypeServiceGrpc.newBlockingStub((Channel)this.channel).withCallCredentials(this.addAuthentication());
    }

    public SagaCurrencyType getCurrencyType(String currencyTypeId) throws SagaException {
        GetCurrencyTypeRequest request = GetCurrencyTypeRequest.newBuilder().setCurrencyTypeId(currencyTypeId).build();
        try {
            CurrencyTypeProto currencyType = this.serviceBlockingStub.getCurrencyType(request);
            ValidateUtil.checkFound(currencyType, String.format("Currency type %s not found", request.getCurrencyTypeId()), new Object[0]);
            return SagaCurrencyType.fromProto(currencyType);
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }

    public List<SagaCurrencyType> getCurrencyTypes(int pageSize, SortOrder sortOrder, Instant createdAtCursor) throws SagaException {
        GetCurrencyTypesRequest request = GetCurrencyTypesRequest.newBuilder().setQueryOptions(CommonFactory.toProto(pageSize, sortOrder, createdAtCursor)).build();
        try {
            CurrencyTypesProto currencies = this.serviceBlockingStub.getCurrencyTypes(request);
            return currencies.getCurrencyTypesList().stream().map(SagaCurrencyType::fromProto).collect(Collectors.toList());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus() == Status.NOT_FOUND) {
                return List.of();
            }
            throw SagaException.fromGrpcException(e);
        }
    }
}

