/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.AbstractSagaStreamClient;
import games.mythical.saga.sdk.client.executor.SagaMetadataExecutor;
import games.mythical.saga.sdk.client.model.SagaMetadata;
import games.mythical.saga.sdk.client.observer.SagaStatusUpdateObserver;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.proto.api.metadata.MetadataServiceGrpc;
import games.mythical.saga.sdk.proto.api.metadata.UpdateItemMetadataRequest;
import games.mythical.saga.sdk.proto.common.ReceivedResponse;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaMetadataClient
extends AbstractSagaStreamClient {
    private static final Logger log = LoggerFactory.getLogger(SagaMetadataClient.class);
    private final SagaMetadataExecutor executor;
    private MetadataServiceGrpc.MetadataServiceBlockingStub serviceBlockingStub;

    SagaMetadataClient(SagaSdkConfig config) throws SagaException {
        this(config, null);
    }

    SagaMetadataClient(SagaSdkConfig config, SagaMetadataExecutor executor) throws SagaException {
        super(config);
        this.executor = executor;
        this.initStub();
    }

    @Override
    void initStub() {
        this.serviceBlockingStub = (MetadataServiceGrpc.MetadataServiceBlockingStub)MetadataServiceGrpc.newBlockingStub((Channel)this.channel).withCallCredentials(this.addAuthentication());
        this.initStreamStub();
        SagaStatusUpdateObserver.getInstance().with(this.executor);
    }

    public String updateItemMetadata(String inventoryId, SagaMetadata metadata) throws SagaException {
        try {
            UpdateItemMetadataRequest request = UpdateItemMetadataRequest.newBuilder().setInventoryId(inventoryId).setMetadata(SagaMetadata.toProto(metadata)).build();
            ReceivedResponse response = this.serviceBlockingStub.updateItemMetadata(request);
            return response.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }
}

