/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.AbstractSagaStreamClient;
import games.mythical.saga.sdk.client.executor.SagaPlayerWalletExecutor;
import games.mythical.saga.sdk.client.model.SagaPlayerWallet;
import games.mythical.saga.sdk.client.observer.SagaStatusUpdateObserver;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.proto.api.playerwallet.CreatePlayerWalletRequest;
import games.mythical.saga.sdk.proto.api.playerwallet.GetPlayerWalletRequest;
import games.mythical.saga.sdk.proto.api.playerwallet.PlayerWalletProto;
import games.mythical.saga.sdk.proto.api.playerwallet.PlayerWalletServiceGrpc;
import games.mythical.saga.sdk.proto.common.ReceivedResponse;
import games.mythical.saga.sdk.util.ValidateUtil;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaPlayerWalletClient
extends AbstractSagaStreamClient {
    private static final Logger log = LoggerFactory.getLogger(SagaPlayerWalletClient.class);
    private final SagaPlayerWalletExecutor executor;
    private PlayerWalletServiceGrpc.PlayerWalletServiceBlockingStub serviceBlockingStub;

    protected SagaPlayerWalletClient(SagaSdkConfig config) throws SagaException {
        this(config, null);
    }

    protected SagaPlayerWalletClient(SagaSdkConfig config, SagaPlayerWalletExecutor executor) throws SagaException {
        super(config);
        this.executor = executor;
        this.initStub();
    }

    @Override
    void initStub() {
        this.serviceBlockingStub = (PlayerWalletServiceGrpc.PlayerWalletServiceBlockingStub)PlayerWalletServiceGrpc.newBlockingStub((Channel)this.channel).withCallCredentials(this.addAuthentication());
        this.initStreamStub();
        SagaStatusUpdateObserver.getInstance().with(this.executor);
    }

    public SagaPlayerWallet getPlayerWallet(String oauthId) throws SagaException {
        GetPlayerWalletRequest request = GetPlayerWalletRequest.newBuilder().setOauthId(oauthId).build();
        try {
            PlayerWalletProto proto = this.serviceBlockingStub.getPlayerWallet(request);
            ValidateUtil.checkFound(proto, String.format("Player wallet %s not found", oauthId), new Object[0]);
            return SagaPlayerWallet.fromProto(proto);
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }

    public String createPlayerWallet(String oauthId) throws SagaException {
        try {
            log.trace("SagaPlayerWalletClient.createPlayerWallet - oauthId: {}", (Object)oauthId);
            CreatePlayerWalletRequest request = CreatePlayerWalletRequest.newBuilder().setOauthId(oauthId).build();
            ReceivedResponse result = this.serviceBlockingStub.createPlayerWallet(request);
            return result.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }
}

