/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client.model;

import games.mythical.saga.sdk.client.model.SagaMetadata;
import games.mythical.saga.sdk.proto.api.item.IssueItemProto;

public class SagaIssueItem {
    private String inventoryId;
    private SagaMetadata metadata;
    private Long tokenId;

    public static IssueItemProto toProto(SagaIssueItem issueItem) {
        return IssueItemProto.newBuilder().setInventoryId(issueItem.getInventoryId()).setMetadata(SagaMetadata.toProto(issueItem.getMetadata())).setTokenId(issueItem.getTokenId().longValue()).build();
    }

    SagaIssueItem(String inventoryId, SagaMetadata metadata, Long tokenId) {
        this.inventoryId = inventoryId;
        this.metadata = metadata;
        this.tokenId = tokenId;
    }

    public static SagaIssueItemBuilder builder() {
        return new SagaIssueItemBuilder();
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public SagaMetadata getMetadata() {
        return this.metadata;
    }

    public Long getTokenId() {
        return this.tokenId;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setMetadata(SagaMetadata metadata) {
        this.metadata = metadata;
    }

    public void setTokenId(Long tokenId) {
        this.tokenId = tokenId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SagaIssueItem)) {
            return false;
        }
        SagaIssueItem other = (SagaIssueItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$tokenId = this.getTokenId();
        Long other$tokenId = other.getTokenId();
        if (this$tokenId == null ? other$tokenId != null : !((Object)this$tokenId).equals(other$tokenId)) {
            return false;
        }
        String this$inventoryId = this.getInventoryId();
        String other$inventoryId = other.getInventoryId();
        if (this$inventoryId == null ? other$inventoryId != null : !this$inventoryId.equals(other$inventoryId)) {
            return false;
        }
        SagaMetadata this$metadata = this.getMetadata();
        SagaMetadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SagaIssueItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tokenId = this.getTokenId();
        result = result * 59 + ($tokenId == null ? 43 : ((Object)$tokenId).hashCode());
        String $inventoryId = this.getInventoryId();
        result = result * 59 + ($inventoryId == null ? 43 : $inventoryId.hashCode());
        SagaMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "SagaIssueItem(inventoryId=" + this.getInventoryId() + ", metadata=" + this.getMetadata() + ", tokenId=" + this.getTokenId() + ")";
    }

    public static class SagaIssueItemBuilder {
        private String inventoryId;
        private SagaMetadata metadata;
        private Long tokenId;

        SagaIssueItemBuilder() {
        }

        public SagaIssueItemBuilder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public SagaIssueItemBuilder metadata(SagaMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public SagaIssueItemBuilder tokenId(Long tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public SagaIssueItem build() {
            return new SagaIssueItem(this.inventoryId, this.metadata, this.tokenId);
        }

        public String toString() {
            return "SagaIssueItem.SagaIssueItemBuilder(inventoryId=" + this.inventoryId + ", metadata=" + this.metadata + ", tokenId=" + this.tokenId + ")";
        }
    }
}

