/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client.observer;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import games.mythical.saga.sdk.client.executor.SagaCurrencyExecutor;
import games.mythical.saga.sdk.client.executor.SagaCurrencyTypeExecutor;
import games.mythical.saga.sdk.client.executor.SagaItemExecutor;
import games.mythical.saga.sdk.client.executor.SagaItemTypeExecutor;
import games.mythical.saga.sdk.client.executor.SagaMetadataExecutor;
import games.mythical.saga.sdk.client.executor.SagaPlayerWalletExecutor;
import games.mythical.saga.sdk.client.executor.SagaReservationExecutor;
import games.mythical.saga.sdk.client.model.SagaItem;
import games.mythical.saga.sdk.client.model.SagaItemUpdate;
import games.mythical.saga.sdk.client.model.SagaUserAmount;
import games.mythical.saga.sdk.client.observer.AbstractObserver;
import games.mythical.saga.sdk.exception.SagaErrorCode;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.exception.SubError;
import games.mythical.saga.sdk.proto.api.itemtype.FailedItemTypeBatch;
import games.mythical.saga.sdk.proto.common.ErrorData;
import games.mythical.saga.sdk.proto.streams.StatusUpdate;
import games.mythical.saga.sdk.proto.streams.currency.BalanceProto;
import games.mythical.saga.sdk.proto.streams.currency.CurrencyStatusUpdate;
import games.mythical.saga.sdk.proto.streams.currency.CurrencyUpdate;
import games.mythical.saga.sdk.proto.streams.currencytype.CurrencyTypeStatusUpdate;
import games.mythical.saga.sdk.proto.streams.currencytype.CurrencyTypeUpdate;
import games.mythical.saga.sdk.proto.streams.item.ItemStatusUpdate;
import games.mythical.saga.sdk.proto.streams.item.ItemUpdate;
import games.mythical.saga.sdk.proto.streams.itemtype.ItemTypeStatusUpdate;
import games.mythical.saga.sdk.proto.streams.itemtype.ItemTypeUpdate;
import games.mythical.saga.sdk.proto.streams.metadata.MetadataUpdate;
import games.mythical.saga.sdk.proto.streams.metadata.MetadataUpdateProto;
import games.mythical.saga.sdk.proto.streams.playerwallet.PlayerWalletStatusUpdate;
import games.mythical.saga.sdk.proto.streams.playerwallet.PlayerWalletUpdate;
import games.mythical.saga.sdk.proto.streams.reservation.ReservationUpdate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SagaStatusUpdateObserver
extends AbstractObserver<StatusUpdate> {
    private static final Logger log = LoggerFactory.getLogger(SagaStatusUpdateObserver.class);
    private static final String PING_TRACE = "ping";
    private static SagaStatusUpdateObserver instance;
    private final Consumer<SagaStatusUpdateObserver> resubscribe;
    private SagaCurrencyExecutor sagaCurrencyExecutor;
    private SagaCurrencyTypeExecutor sagaCurrencyTypeExecutor;
    private SagaItemExecutor sagaItemExecutor;
    private SagaItemTypeExecutor sagaItemTypeExecutor;
    private SagaPlayerWalletExecutor sagaPlayerWalletExecutor;
    private SagaReservationExecutor sagaReservationExecutor;
    private SagaMetadataExecutor sagaMetadataExecutor;

    public SagaStatusUpdateObserver(Consumer<SagaStatusUpdateObserver> resubscribe) {
        this.resubscribe = resubscribe;
    }

    public static SagaStatusUpdateObserver getInstance() {
        return instance;
    }

    public static SagaStatusUpdateObserver initialize(Consumer<SagaStatusUpdateObserver> resubscribe) {
        instance = new SagaStatusUpdateObserver(resubscribe);
        return instance;
    }

    public static void clear() {
        instance = null;
    }

    public SagaStatusUpdateObserver with(SagaCurrencyExecutor sagaCurrencyExecutor) {
        this.sagaCurrencyExecutor = sagaCurrencyExecutor;
        return this;
    }

    public SagaStatusUpdateObserver with(SagaCurrencyTypeExecutor sagaCurrencyTypeExecutor) {
        this.sagaCurrencyTypeExecutor = sagaCurrencyTypeExecutor;
        return this;
    }

    public SagaStatusUpdateObserver with(SagaItemExecutor sagaItemExecutor) {
        this.sagaItemExecutor = sagaItemExecutor;
        return this;
    }

    public SagaStatusUpdateObserver with(SagaItemTypeExecutor sagaItemTypeExecutor) {
        this.sagaItemTypeExecutor = sagaItemTypeExecutor;
        return this;
    }

    public SagaStatusUpdateObserver with(SagaPlayerWalletExecutor sagaPlayerWalletExecutor) {
        this.sagaPlayerWalletExecutor = sagaPlayerWalletExecutor;
        return this;
    }

    public SagaStatusUpdateObserver with(SagaReservationExecutor sagaReservationExecutor) {
        this.sagaReservationExecutor = sagaReservationExecutor;
        return this;
    }

    public SagaStatusUpdateObserver with(SagaMetadataExecutor sagaMetadataExecutor) {
        this.sagaMetadataExecutor = sagaMetadataExecutor;
        return this;
    }

    public void onNext(StatusUpdate message) {
        log.trace("StatusUpdateObserver.onNext for event {} with message {}", (Object)message.getStatusUpdateCase(), (Object)message.getTraceId());
        this.resetConnectionRetry();
        if (message.getTraceId().equalsIgnoreCase(PING_TRACE)) {
            return;
        }
        try {
            switch (message.getStatusUpdateCase()) {
                case CURRENCY_UPDATE: {
                    this.handleCurrencyUpdate(message.getCurrencyUpdate(), message.getTraceId());
                    break;
                }
                case CURRENCY_TYPE_UPDATE: {
                    this.handleCurrencyTypeUpdate(message.getCurrencyTypeUpdate(), message.getTraceId());
                    break;
                }
                case ITEM_UPDATE: {
                    this.handleItemUpdate(message.getItemUpdate(), message.getTraceId());
                    break;
                }
                case METADATA_UPDATE: {
                    this.handleMetadataUpdate(message.getMetadataUpdate(), message.getTraceId());
                    break;
                }
                case ITEM_TYPE_UPDATE: {
                    this.handleItemTypeUpdate(message.getItemTypeUpdate(), message.getTraceId());
                    break;
                }
                case PLAYER_WALLET_UPDATE: {
                    this.handlePlayerWalletUpdate(message.getPlayerWalletUpdate(), message.getTraceId());
                    break;
                }
                case RESERVATION_UPDATE: {
                    this.handleReservationUpdate(message.getReservationUpdate(), message.getTraceId());
                    break;
                }
                default: {
                    log.error("Unrecognized event {}", (Object)message.getStatusUpdateCase());
                    throw new SagaException(SagaErrorCode.UNRECOGNIZED);
                }
            }
        }
        catch (Exception e) {
            log.error("Exception calling executor action for message:{}. {}", (Object)message.getTraceId(), (Object)e);
        }
    }

    public void onError(Throwable t) {
        log.error("StatusUpdateObserver.onError", t);
        this.sleepBetweenReconnects();
        this.resubscribe.accept(this);
    }

    public void onCompleted() {
        log.info("StatusUpdateObserver stream closed");
        this.sleepBetweenReconnects();
        this.resubscribe.accept(this);
    }

    private void handleCurrencyUpdate(CurrencyUpdate update, String traceId) throws Exception {
        if (this.sagaCurrencyExecutor == null) {
            log.debug("Currency update received, but no currency executor registered {}", (Object)update);
        } else if (update.hasError()) {
            ErrorData error = update.getError();
            this.sagaCurrencyExecutor.onError(this.toErrData(error));
        } else {
            CurrencyStatusUpdate message = update.getStatusUpdate();
            if (message.getBalancesList().isEmpty()) {
                log.error("No balances were issued, this shouldn't have occurred. {}", (Object)traceId);
                return;
            }
            switch (message.getCurrencyState()) {
                case ISSUED: {
                    List<SagaUserAmount> balances = message.getBalancesList().stream().map(balance -> new SagaUserAmount(balance.getOauthId(), balance.getBalanceInWei())).collect(Collectors.toList());
                    this.sagaCurrencyExecutor.currencyIssued(((BalanceProto)message.getBalancesList().get(0)).getCurrencyTypeId(), message.getTransactionId(), balances, message.getIdempotencyId(), traceId);
                    break;
                }
                default: {
                    BalanceProto balance2 = (BalanceProto)message.getBalancesList().stream().findFirst().get();
                    this.sagaCurrencyExecutor.updateCurrency(balance2.getCurrencyTypeId(), message.getTransactionId(), balance2.getOauthId(), balance2.getBalanceInWei(), message.getIdempotencyId(), traceId, message.getCurrencyState());
                }
            }
        }
    }

    private void handleCurrencyTypeUpdate(CurrencyTypeUpdate update, String traceId) throws Exception {
        if (this.sagaCurrencyTypeExecutor == null) {
            log.debug("CurrencyType update received, but no currencytype executor registered {}", (Object)update);
        } else if (update.hasError()) {
            ErrorData error = update.getError();
            this.sagaCurrencyTypeExecutor.onError(this.toErrData(error));
        } else {
            CurrencyTypeStatusUpdate message = update.getStatusUpdate();
            this.sagaCurrencyTypeExecutor.updateCurrencyType(message.getCurrencyTypeId(), traceId, message.getCurrencyTypeState());
        }
    }

    private void handleItemUpdate(ItemUpdate update, String traceId) throws Exception {
        if (this.sagaItemExecutor == null) {
            log.debug("Item update received, but no item executor registered {}", (Object)update);
        } else if (update.hasError()) {
            ErrorData error = update.getError();
            this.sagaItemExecutor.onError(this.toErrData(error));
        } else if (update.hasStatusUpdate()) {
            ItemStatusUpdate message = update.getStatusUpdate();
            this.sagaItemExecutor.updateItem(message.getInventoryId(), message.getItemTypeId(), message.getOauthId(), message.getTokenId(), message.getMetadataUrl(), traceId, message.getItemState());
        } else {
            List<SagaItemUpdate> updates = update.getStatusUpdates().getStatusUpdatesList().stream().map(SagaItemUpdate::fromProto).collect(Collectors.toList());
            this.sagaItemExecutor.updateItems(updates, traceId);
        }
    }

    private void handleMetadataUpdate(MetadataUpdate update, String traceId) throws Exception {
        if (this.sagaMetadataExecutor == null) {
            log.debug("Metadata update received, but no metadata executor registered {}", (Object)update);
        } else if (update.hasError()) {
            ErrorData error = update.getError();
            this.sagaItemExecutor.onError(this.toErrData(error));
        } else {
            MetadataUpdateProto message = update.getMetadataUpdated();
            this.sagaMetadataExecutor.updateMetadata(message.getInventoryId(), message.getMetadataUrl(), traceId);
        }
    }

    private void handleItemTypeUpdate(ItemTypeUpdate update, String traceId) throws Exception {
        if (this.sagaItemTypeExecutor == null) {
            log.debug("Item type update received, but no item type executor registered {}", (Object)update);
        } else if (update.hasError()) {
            ErrorData error = update.getError();
            this.sagaItemTypeExecutor.onError(this.toErrData(error));
        } else {
            ItemTypeStatusUpdate message = update.getStatusUpdate();
            this.sagaItemTypeExecutor.updateItemType(message.getItemTypeId(), traceId, message.getItemTypeState());
        }
    }

    private void handlePlayerWalletUpdate(PlayerWalletUpdate update, String traceId) throws Exception {
        if (this.sagaPlayerWalletExecutor == null) {
            log.debug("Player wallet update received, but no player wallet executor registered {}", (Object)update);
        } else if (update.hasError()) {
            ErrorData error = update.getError();
            this.sagaPlayerWalletExecutor.onError(this.toErrData(error));
        } else {
            PlayerWalletStatusUpdate statusUpdate = update.getStatusUpdate();
            this.sagaPlayerWalletExecutor.updatePlayerWallet(traceId, statusUpdate.getOauthId());
        }
    }

    private void handleReservationUpdate(ReservationUpdate update, String traceId) {
        if (this.sagaReservationExecutor == null) {
            log.debug("Reservation update received, but no reservation executor registered {}", (Object)update);
        } else {
            switch (update.getUpdateCase()) {
                case ERROR: {
                    this.sagaReservationExecutor.onError(this.toErrData(update.getError()));
                    break;
                }
                case RESERVATION_CREATED: {
                    this.sagaReservationExecutor.onReservationCreated(update.getReservationCreated().getReservationId(), traceId);
                    break;
                }
                case RESERVATION_RELEASED: {
                    this.sagaReservationExecutor.onReservationReleased(update.getReservationReleased().getReservationId(), traceId);
                    break;
                }
                case RESERVATION_REDEEMED: {
                    List<SagaItem> items = update.getReservationRedeemed().getItemsList().stream().map(SagaItem::fromProto).collect(Collectors.toList());
                    List<String> failedBatches = update.getReservationRedeemed().getFailedBatchesList().stream().map(FailedItemTypeBatch::getItemTypeId).collect(Collectors.toList());
                    this.sagaReservationExecutor.onReservationRedeemed(update.getReservationRedeemed().getReservationId(), items, failedBatches, traceId);
                    break;
                }
                default: {
                    log.error("Unknown reservation update: {}", (Object)update.getUpdateCase());
                }
            }
        }
    }

    private Map<String, String> toMetadata(Struct protoMetadata) {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        protoMetadata.getFieldsMap().forEach((key, value) -> metadataMap.put((String)key, this.metadataValueToString((Value)value)));
        return metadataMap;
    }

    private String metadataValueToString(Value value) {
        if (value.hasNullValue()) {
            return null;
        }
        if (value.hasStringValue()) {
            return value.getStringValue();
        }
        return value.toString();
    }

    private SubError toSubError(games.mythical.saga.sdk.proto.common.SubError error) {
        return SubError.builder().code(error.getErrorCode()).message(error.getMessage()).source(error.getSource()).metadata(this.toMetadata(error.getMetadata())).build();
    }

    private games.mythical.saga.sdk.exception.ErrorData toErrData(ErrorData error) {
        List<SubError> subErrors = error.getSuberrorsList().stream().map(this::toSubError).collect(Collectors.toList());
        return games.mythical.saga.sdk.exception.ErrorData.builder().code(error.getErrorCode()).trace(error.getTrace()).source(error.getSource()).message(error.getMessage()).metadata(this.toMetadata(error.getMetadata())).suberrors(subErrors).build();
    }
}

