/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.JsonFormat;
import com.google.protobuf.util.Timestamps;
import games.mythical.saga.sdk.exception.SagaErrorCode;
import games.mythical.saga.sdk.exception.SagaException;
import java.time.Instant;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionUtils {
    private static final Logger log = LoggerFactory.getLogger(ConversionUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);

    public static Struct convertProperties(Map<String, Object> properties) throws SagaException {
        try {
            String metadataJson = objectMapper.writeValueAsString(properties);
            Struct.Builder structBuilder = Struct.newBuilder();
            JsonFormat.parser().merge(metadataJson, (Message.Builder)structBuilder);
            return structBuilder.build();
        }
        catch (JsonProcessingException | InvalidProtocolBufferException e) {
            log.error("ConversionUtils: couldn't convert properties map!", e);
            throw new SagaException(SagaErrorCode.PARSING_DATA_EXCEPTION);
        }
    }

    public static Map<String, Object> convertProperties(Struct properties) throws SagaException {
        try {
            String propertiesString = JsonFormat.printer().print((MessageOrBuilder)properties);
            return (Map)objectMapper.readValue(propertiesString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            log.error("ConversionUtils: couldn't convert properties struct!", (Throwable)e);
            throw new SagaException(SagaErrorCode.PARSING_DATA_EXCEPTION);
        }
    }

    public static Map<String, Object> toStringObjectMap(String stringObjectJson) throws SagaException {
        try {
            return (Map)objectMapper.readValue(stringObjectJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("ConversionUtils: couldn't convert JSON into String, Object map", (Throwable)e);
            throw new SagaException(SagaErrorCode.PARSING_DATA_EXCEPTION);
        }
    }

    public static Instant protoTimestampToInstant(Timestamp timestamp) {
        return Instant.ofEpochMilli(Timestamps.toMillis((Timestamp)timestamp));
    }

    public static Timestamp instantToProtoTimestamp(Instant instant) {
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }
}

