/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.AbstractSagaStreamClient;
import games.mythical.saga.sdk.client.executor.SagaCurrencyExecutor;
import games.mythical.saga.sdk.client.model.SagaBalanceOfPlayer;
import games.mythical.saga.sdk.client.model.SagaBalancesOfPlayer;
import games.mythical.saga.sdk.client.model.SagaUserAmount;
import games.mythical.saga.sdk.client.observer.SagaStatusUpdateObserver;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaErrorCode;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.factory.CommonFactory;
import games.mythical.saga.sdk.proto.api.currency.BalanceOfPlayerProto;
import games.mythical.saga.sdk.proto.api.currency.BalancesOfPlayerProto;
import games.mythical.saga.sdk.proto.api.currency.BurnCurrencyRequest;
import games.mythical.saga.sdk.proto.api.currency.CurrencyServiceGrpc;
import games.mythical.saga.sdk.proto.api.currency.GetBalanceOfPlayerRequest;
import games.mythical.saga.sdk.proto.api.currency.GetBalancesOfPlayerRequest;
import games.mythical.saga.sdk.proto.api.currency.IssueCurrencyRequest;
import games.mythical.saga.sdk.proto.api.currency.TransferCurrencyRequest;
import games.mythical.saga.sdk.proto.api.currency.UserAmountProto;
import games.mythical.saga.sdk.proto.common.ReceivedResponse;
import games.mythical.saga.sdk.proto.common.SortOrder;
import games.mythical.saga.sdk.util.ValidateUtil;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaCurrencyClient
extends AbstractSagaStreamClient {
    private static final Logger log = LoggerFactory.getLogger(SagaCurrencyClient.class);
    private final SagaCurrencyExecutor executor;
    private CurrencyServiceGrpc.CurrencyServiceBlockingStub serviceBlockingStub;

    SagaCurrencyClient(SagaSdkConfig config) throws SagaException {
        this(config, null);
    }

    SagaCurrencyClient(SagaSdkConfig config, SagaCurrencyExecutor executor) throws SagaException {
        super(config);
        this.executor = executor;
        this.initStub();
    }

    @Override
    void initStub() {
        this.serviceBlockingStub = (CurrencyServiceGrpc.CurrencyServiceBlockingStub)CurrencyServiceGrpc.newBlockingStub((Channel)this.channel).withCallCredentials(this.addAuthentication());
        this.initStreamStub();
        SagaStatusUpdateObserver.getInstance().with(this.executor);
    }

    public String issueCurrency(String currencyTypeId, List<SagaUserAmount> userAmounts, String idempotencyId) throws SagaException {
        ArrayList amounts = new ArrayList();
        userAmounts.forEach(userAmount -> amounts.add(UserAmountProto.newBuilder().setAmountInWei(userAmount.getAmountInWei()).setOauthId(userAmount.getOauthId()).build()));
        IssueCurrencyRequest request = IssueCurrencyRequest.newBuilder().setCurrencyTypeId(currencyTypeId).addAllUserAmounts(amounts).setIdempotencyId(idempotencyId).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.issueCurrency(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on issueCurrency, coin may be lost!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String transferCurrency(String currencyTypeId, String sourceOauthId, String destOauthId, String amountInWei, Boolean prefundGas, String idempotencyId) throws SagaException {
        TransferCurrencyRequest request = TransferCurrencyRequest.newBuilder().setCurrencyTypeId(currencyTypeId).setSourceOauthId(sourceOauthId).setDestOauthId(destOauthId).setAmountInWei(amountInWei).setPrefundGas(prefundGas.booleanValue()).setIdempotencyId(idempotencyId).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.transferCurrency(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on transferCurrency, coin may be out of sync!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String burnCurrency(String currencyTypeId, String oauthId, String amountInWei, Boolean prefundGas, String idempotencyId) throws SagaException {
        BurnCurrencyRequest request = BurnCurrencyRequest.newBuilder().setCurrencyTypeId(currencyTypeId).setOauthId(oauthId).setAmountInWei(amountInWei).setPrefundGas(prefundGas.booleanValue()).setIdempotencyId(idempotencyId).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.burnCurrency(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on burnCurrency, coin may be out of sync!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public SagaBalanceOfPlayer getBalanceOfPlayer(String currencyTypeId, String oauthId) throws SagaException {
        GetBalanceOfPlayerRequest request = GetBalanceOfPlayerRequest.newBuilder().setCurrencyTypeId(currencyTypeId).setOauthId(oauthId).build();
        try {
            BalanceOfPlayerProto balance = this.serviceBlockingStub.getBalanceOfPlayer(request);
            ValidateUtil.checkFound(balance, String.format("Unable to get currency %s balance for player %s", currencyTypeId, oauthId), new Object[0]);
            return SagaBalanceOfPlayer.fromProto(balance);
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }

    public SagaBalancesOfPlayer getBalancesOfPlayer(String oauthId, int pageSize, SortOrder sortOrder, Instant createdAtCursor) throws SagaException {
        GetBalancesOfPlayerRequest request = GetBalancesOfPlayerRequest.newBuilder().setOauthId(oauthId).setQueryOptions(CommonFactory.toProto(pageSize, sortOrder, createdAtCursor)).build();
        try {
            BalancesOfPlayerProto balances = this.serviceBlockingStub.getBalancesOfPlayer(request);
            ValidateUtil.checkFound(balances, String.format("Unable to get currency balances for player %s", oauthId), new Object[0]);
            return SagaBalancesOfPlayer.fromProto(balances);
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }
}

