/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.AbstractSagaStreamClient;
import games.mythical.saga.sdk.client.executor.SagaItemTypeExecutor;
import games.mythical.saga.sdk.client.model.SagaItemType;
import games.mythical.saga.sdk.client.observer.SagaStatusUpdateObserver;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaErrorCode;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.factory.CommonFactory;
import games.mythical.saga.sdk.proto.api.itemtype.CreateItemTypeRequest;
import games.mythical.saga.sdk.proto.api.itemtype.EndMintRequest;
import games.mythical.saga.sdk.proto.api.itemtype.GetItemTypeRequest;
import games.mythical.saga.sdk.proto.api.itemtype.GetItemTypesRequest;
import games.mythical.saga.sdk.proto.api.itemtype.ItemTypeProto;
import games.mythical.saga.sdk.proto.api.itemtype.ItemTypeServiceGrpc;
import games.mythical.saga.sdk.proto.api.itemtype.ItemTypesProto;
import games.mythical.saga.sdk.proto.api.itemtype.MintMode;
import games.mythical.saga.sdk.proto.api.itemtype.StartMintRequest;
import games.mythical.saga.sdk.proto.common.ReceivedResponse;
import games.mythical.saga.sdk.proto.common.SortOrder;
import games.mythical.saga.sdk.util.ConversionUtils;
import games.mythical.saga.sdk.util.ValidateUtil;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Instant;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaItemTypeClient
extends AbstractSagaStreamClient {
    private static final Logger log = LoggerFactory.getLogger(SagaItemTypeClient.class);
    private final SagaItemTypeExecutor executor;
    private ItemTypeServiceGrpc.ItemTypeServiceBlockingStub serviceBlockingStub;

    SagaItemTypeClient(SagaSdkConfig config) throws SagaException {
        this(config, null);
    }

    SagaItemTypeClient(SagaSdkConfig config, SagaItemTypeExecutor executor) throws SagaException {
        super(config);
        this.executor = executor;
        this.initStub();
    }

    @Override
    void initStub() {
        this.serviceBlockingStub = (ItemTypeServiceGrpc.ItemTypeServiceBlockingStub)ItemTypeServiceGrpc.newBlockingStub((Channel)this.channel).withCallCredentials(this.addAuthentication());
        this.initStreamStub();
        SagaStatusUpdateObserver.getInstance().with(this.executor);
    }

    public SagaItemType getItemType(String itemTypeId) throws SagaException {
        GetItemTypeRequest request = GetItemTypeRequest.newBuilder().setItemTypeId(itemTypeId).build();
        try {
            ItemTypeProto item = this.serviceBlockingStub.getItemType(request);
            ValidateUtil.checkFound(item, String.format("Unable to find item %s", request.getItemTypeId()), new Object[0]);
            return SagaItemType.fromProto(item);
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }

    public List<SagaItemType> getItemTypes(String gameTitleId, String publisherAddress, int pageSize, SortOrder sortOrder, Instant createdAtCursor) throws SagaException {
        GetItemTypesRequest request = GetItemTypesRequest.newBuilder().setGameTitleId(StringUtils.defaultString((String)gameTitleId)).setPublisherAddress(StringUtils.defaultString((String)publisherAddress)).setQueryOptions(CommonFactory.toProto(pageSize, sortOrder, createdAtCursor)).build();
        try {
            ItemTypesProto result = this.serviceBlockingStub.getItemTypes(request);
            return SagaItemType.fromProto(result.getItemTypesList());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus() == Status.NOT_FOUND) {
                return List.of();
            }
            throw SagaException.fromGrpcException(e);
        }
    }

    public String createItemType(String itemTypeId, String name, String symbol, int maxSupply, Instant dateFinished, MintMode mintMode) throws SagaException {
        try {
            if (itemTypeId.isBlank()) {
                String msg = "itemTypeId cannot be empty";
                log.error(msg);
                throw new SagaException(SagaErrorCode.PARSING_DATA_EXCEPTION, msg);
            }
            log.trace("ItemTypeClient.createItemType called for game item type id: {}", (Object)itemTypeId);
            CreateItemTypeRequest.Builder builder = CreateItemTypeRequest.newBuilder().setItemTypeId(itemTypeId).setName(name).setSymbol(symbol).setMaxSupply((long)maxSupply).setMintMode(mintMode);
            if (dateFinished != null) {
                builder.setDateFinished(ConversionUtils.instantToProtoTimestamp(dateFinished));
            }
            ReceivedResponse result = this.serviceBlockingStub.createItemType(builder.build());
            return result.getTraceId();
        }
        catch (SagaException e) {
            throw e;
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on createItemType, item type may be lost!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String startMint(String itemTypeId) throws SagaException {
        try {
            log.trace("ItemTypeClient.startMint called for {}", (Object)itemTypeId);
            StartMintRequest request = StartMintRequest.newBuilder().setItemTypeId(itemTypeId).build();
            ReceivedResponse result = this.serviceBlockingStub.startMint(request);
            return result.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling startMint", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String endMint(String itemTypeId) throws SagaException {
        try {
            log.trace("ItemTypeClient.endMint called for {}", (Object)itemTypeId);
            EndMintRequest request = EndMintRequest.newBuilder().setItemTypeId(itemTypeId).build();
            ReceivedResponse result = this.serviceBlockingStub.endMint(request);
            return result.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling endMint", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }
}

