/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client.model;

import games.mythical.proto_util.ProtoUtil;
import games.mythical.proto_util.dto.DtoExclude;
import games.mythical.saga.sdk.client.model.SagaBalance;
import games.mythical.saga.sdk.proto.api.currencytype.CurrencyTypeProto;
import games.mythical.saga.sdk.util.ConversionUtils;
import java.time.Instant;

public class SagaCurrencyType {
    private String traceId;
    private String currencyTypeId;
    private String name;
    private String symbol;
    private String imageUrl;
    private String contractAddress;
    private String transactionId;
    private long maxSupply;
    @DtoExclude
    private SagaBalance publisherBalance;
    @DtoExclude
    private Instant createdAt;
    @DtoExclude
    private Instant updatedAt;

    public static SagaCurrencyType fromProto(CurrencyTypeProto proto) {
        SagaCurrencyType currencyType = (SagaCurrencyType)ProtoUtil.toDto((Object)proto, SagaCurrencyType.class);
        if (proto.hasPublisherBalance()) {
            SagaBalance publisherBalance = SagaBalance.builder().address(proto.getPublisherBalance().getPublisherAddress()).balanceInWei(proto.getPublisherBalance().getBalanceInWei()).build();
            currencyType.setPublisherBalance(publisherBalance);
        }
        Instant createdAt = ConversionUtils.protoTimestampToInstant(proto.getCreatedAt());
        currencyType.setCreatedAt(createdAt);
        Instant updatedAt = ConversionUtils.protoTimestampToInstant(proto.getUpdatedAt());
        currencyType.setUpdatedAt(updatedAt);
        return currencyType;
    }

    public static SagaCurrencyTypeBuilder builder() {
        return new SagaCurrencyTypeBuilder();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getCurrencyTypeId() {
        return this.currencyTypeId;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public long getMaxSupply() {
        return this.maxSupply;
    }

    public SagaBalance getPublisherBalance() {
        return this.publisherBalance;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setCurrencyTypeId(String currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setMaxSupply(long maxSupply) {
        this.maxSupply = maxSupply;
    }

    public void setPublisherBalance(SagaBalance publisherBalance) {
        this.publisherBalance = publisherBalance;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SagaCurrencyType)) {
            return false;
        }
        SagaCurrencyType other = (SagaCurrencyType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxSupply() != other.getMaxSupply()) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$currencyTypeId = this.getCurrencyTypeId();
        String other$currencyTypeId = other.getCurrencyTypeId();
        if (this$currencyTypeId == null ? other$currencyTypeId != null : !this$currencyTypeId.equals(other$currencyTypeId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        SagaBalance this$publisherBalance = this.getPublisherBalance();
        SagaBalance other$publisherBalance = other.getPublisherBalance();
        if (this$publisherBalance == null ? other$publisherBalance != null : !((Object)this$publisherBalance).equals(other$publisherBalance)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SagaCurrencyType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxSupply = this.getMaxSupply();
        result = result * 59 + (int)($maxSupply >>> 32 ^ $maxSupply);
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $currencyTypeId = this.getCurrencyTypeId();
        result = result * 59 + ($currencyTypeId == null ? 43 : $currencyTypeId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        SagaBalance $publisherBalance = this.getPublisherBalance();
        result = result * 59 + ($publisherBalance == null ? 43 : ((Object)$publisherBalance).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    public String toString() {
        return "SagaCurrencyType(traceId=" + this.getTraceId() + ", currencyTypeId=" + this.getCurrencyTypeId() + ", name=" + this.getName() + ", symbol=" + this.getSymbol() + ", imageUrl=" + this.getImageUrl() + ", contractAddress=" + this.getContractAddress() + ", transactionId=" + this.getTransactionId() + ", maxSupply=" + this.getMaxSupply() + ", publisherBalance=" + this.getPublisherBalance() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }

    public SagaCurrencyType(String traceId, String currencyTypeId, String name, String symbol, String imageUrl, String contractAddress, String transactionId, long maxSupply, SagaBalance publisherBalance, Instant createdAt, Instant updatedAt) {
        this.traceId = traceId;
        this.currencyTypeId = currencyTypeId;
        this.name = name;
        this.symbol = symbol;
        this.imageUrl = imageUrl;
        this.contractAddress = contractAddress;
        this.transactionId = transactionId;
        this.maxSupply = maxSupply;
        this.publisherBalance = publisherBalance;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SagaCurrencyType() {
    }

    public static class SagaCurrencyTypeBuilder {
        private String traceId;
        private String currencyTypeId;
        private String name;
        private String symbol;
        private String imageUrl;
        private String contractAddress;
        private String transactionId;
        private long maxSupply;
        private SagaBalance publisherBalance;
        private Instant createdAt;
        private Instant updatedAt;

        SagaCurrencyTypeBuilder() {
        }

        public SagaCurrencyTypeBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public SagaCurrencyTypeBuilder currencyTypeId(String currencyTypeId) {
            this.currencyTypeId = currencyTypeId;
            return this;
        }

        public SagaCurrencyTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SagaCurrencyTypeBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public SagaCurrencyTypeBuilder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public SagaCurrencyTypeBuilder contractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public SagaCurrencyTypeBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public SagaCurrencyTypeBuilder maxSupply(long maxSupply) {
            this.maxSupply = maxSupply;
            return this;
        }

        public SagaCurrencyTypeBuilder publisherBalance(SagaBalance publisherBalance) {
            this.publisherBalance = publisherBalance;
            return this;
        }

        public SagaCurrencyTypeBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SagaCurrencyTypeBuilder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SagaCurrencyType build() {
            return new SagaCurrencyType(this.traceId, this.currencyTypeId, this.name, this.symbol, this.imageUrl, this.contractAddress, this.transactionId, this.maxSupply, this.publisherBalance, this.createdAt, this.updatedAt);
        }

        public String toString() {
            return "SagaCurrencyType.SagaCurrencyTypeBuilder(traceId=" + this.traceId + ", currencyTypeId=" + this.currencyTypeId + ", name=" + this.name + ", symbol=" + this.symbol + ", imageUrl=" + this.imageUrl + ", contractAddress=" + this.contractAddress + ", transactionId=" + this.transactionId + ", maxSupply=" + this.maxSupply + ", publisherBalance=" + this.publisherBalance + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

