/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client.model;

import com.google.protobuf.DoubleValue;
import games.mythical.proto_util.ProtoUtil;
import games.mythical.proto_util.dto.DtoExclude;
import games.mythical.proto_util.proto.ProtoExclude;
import games.mythical.saga.sdk.proto.common.MetadataAttribute;

public class SagaMetadataAttribute {
    @ProtoExclude
    @DtoExclude
    private Object value;
    private String traitType;
    private String displayType;
    @ProtoExclude
    @DtoExclude
    private Double maxValue;

    public static SagaMetadataAttribute fromProto(MetadataAttribute proto) {
        SagaMetadataAttributeBuilder builder = (SagaMetadataAttributeBuilder)ProtoUtil.toDtoBuilder((Object)proto, SagaMetadataAttributeBuilder.class);
        if (proto.hasStrValue()) {
            builder.value(proto.getStrValue());
        } else if (proto.hasIntValue()) {
            builder.value(proto.getIntValue());
        } else if (proto.hasDoubleValue()) {
            builder.value(proto.getDoubleValue());
        }
        if (proto.hasMaxValue()) {
            builder.maxValue(proto.getMaxValue().getValue());
        }
        return (SagaMetadataAttribute)ProtoUtil.toDto((Object)proto, SagaMetadataAttribute.class);
    }

    public static MetadataAttribute toProto(SagaMetadataAttribute attribute) {
        MetadataAttribute.Builder builder = (MetadataAttribute.Builder)ProtoUtil.toProtoBuilder((Object)attribute, MetadataAttribute.Builder.class);
        if (attribute.getValue() instanceof String) {
            builder.setStrValue((String)attribute.getValue());
        } else if (attribute.getValue() instanceof Integer || attribute.getValue() instanceof Long) {
            builder.setIntValue(((Number)attribute.getValue()).longValue());
        } else if (attribute.getValue() instanceof Float || attribute.getValue() instanceof Double) {
            builder.setDoubleValue(((Number)attribute.getValue()).doubleValue());
        }
        if (attribute.getMaxValue() != null) {
            builder.setMaxValue(DoubleValue.newBuilder().setValue(attribute.getMaxValue().doubleValue()).build());
        }
        return builder.build();
    }

    SagaMetadataAttribute(Object value, String traitType, String displayType, Double maxValue) {
        this.value = value;
        this.traitType = traitType;
        this.displayType = displayType;
        this.maxValue = maxValue;
    }

    public static SagaMetadataAttributeBuilder builder() {
        return new SagaMetadataAttributeBuilder();
    }

    public Object getValue() {
        return this.value;
    }

    public String getTraitType() {
        return this.traitType;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setTraitType(String traitType) {
        this.traitType = traitType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SagaMetadataAttribute)) {
            return false;
        }
        SagaMetadataAttribute other = (SagaMetadataAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$maxValue = this.getMaxValue();
        Double other$maxValue = other.getMaxValue();
        if (this$maxValue == null ? other$maxValue != null : !((Object)this$maxValue).equals(other$maxValue)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$traitType = this.getTraitType();
        String other$traitType = other.getTraitType();
        if (this$traitType == null ? other$traitType != null : !this$traitType.equals(other$traitType)) {
            return false;
        }
        String this$displayType = this.getDisplayType();
        String other$displayType = other.getDisplayType();
        return !(this$displayType == null ? other$displayType != null : !this$displayType.equals(other$displayType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SagaMetadataAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $maxValue = this.getMaxValue();
        result = result * 59 + ($maxValue == null ? 43 : ((Object)$maxValue).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $traitType = this.getTraitType();
        result = result * 59 + ($traitType == null ? 43 : $traitType.hashCode());
        String $displayType = this.getDisplayType();
        result = result * 59 + ($displayType == null ? 43 : $displayType.hashCode());
        return result;
    }

    public String toString() {
        return "SagaMetadataAttribute(value=" + this.getValue() + ", traitType=" + this.getTraitType() + ", displayType=" + this.getDisplayType() + ", maxValue=" + this.getMaxValue() + ")";
    }

    public static class SagaMetadataAttributeBuilder {
        private Object value;
        private String traitType;
        private String displayType;
        private Double maxValue;

        SagaMetadataAttributeBuilder() {
        }

        public SagaMetadataAttributeBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public SagaMetadataAttributeBuilder traitType(String traitType) {
            this.traitType = traitType;
            return this;
        }

        public SagaMetadataAttributeBuilder displayType(String displayType) {
            this.displayType = displayType;
            return this;
        }

        public SagaMetadataAttributeBuilder maxValue(Double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public SagaMetadataAttribute build() {
            return new SagaMetadataAttribute(this.value, this.traitType, this.displayType, this.maxValue);
        }

        public String toString() {
            return "SagaMetadataAttribute.SagaMetadataAttributeBuilder(value=" + this.value + ", traitType=" + this.traitType + ", displayType=" + this.displayType + ", maxValue=" + this.maxValue + ")";
        }
    }
}

