/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.SagaClientFactory;
import games.mythical.saga.sdk.client.SagaCredentialsFactory;
import games.mythical.saga.sdk.client.observer.SagaStatusUpdateObserver;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaException;
import io.grpc.CallCredentials;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSagaClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractSagaClient.class);
    protected final SagaSdkConfig config;
    protected final SagaCredentialsFactory sagaCredentialsFactory;
    protected ManagedChannel channel;

    protected AbstractSagaClient(SagaSdkConfig config) throws SagaException {
        this.config = config;
        this.channel = AbstractSagaClient.buildChannel(config);
        this.sagaCredentialsFactory = SagaCredentialsFactory.getInstance();
    }

    private static ManagedChannel buildChannel(SagaSdkConfig config) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)config.getHost(), (int)config.getPort()).keepAliveTime((long)config.getKeepAlive(), TimeUnit.SECONDS);
        if (config.isPlainText() && SagaClientFactory.ALLOWED_UNENCRYPTED_HOSTS.contains(config.getHost())) {
            builder.usePlaintext();
        }
        return builder.build();
    }

    abstract void initStub();

    public CallCredentials addAuthentication() {
        return new CallCredentials(){

            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                Metadata metadata = new Metadata();
                metadata.put(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)("Bearer " + AbstractSagaClient.this.sagaCredentialsFactory.getToken()));
                applier.apply(metadata);
            }

            public void thisUsesUnstableApi() {
            }
        };
    }

    public void stop() {
        log.info("Stopping client: {}", (Object)this.getClass().getName());
        SagaStatusUpdateObserver.clear();
        this.channel.shutdownNow();
    }
}

