/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.AbstractSagaClient;
import games.mythical.saga.sdk.client.observer.SagaStatusUpdateObserver;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.proto.streams.StatusStreamGrpc;
import games.mythical.saga.sdk.proto.streams.Subscribe;
import games.mythical.saga.sdk.util.ConversionUtils;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSagaStreamClient
extends AbstractSagaClient {
    protected AbstractSagaStreamClient(SagaSdkConfig config) throws SagaException {
        super(config);
    }

    protected void initStreamStub() {
        if (SagaStatusUpdateObserver.getInstance() == null) {
            this.subscribeToStream(SagaStatusUpdateObserver.initialize(this::subscribeToStream));
        }
    }

    protected void subscribeToStream(SagaStatusUpdateObserver observer) {
        StatusStreamGrpc.StatusStreamStub streamStub = (StatusStreamGrpc.StatusStreamStub)StatusStreamGrpc.newStub((Channel)this.channel).withCallCredentials(this.addAuthentication());
        Subscribe.Builder subscribeBuilder = Subscribe.newBuilder().setTitleId(this.config.getTitleId()).setStreamId((String)StringUtils.defaultIfBlank((CharSequence)this.config.getStreamId(), (CharSequence)""));
        if (this.config.getStreamReplaySince() != null) {
            subscribeBuilder.setReplaySince(ConversionUtils.instantToProtoTimestamp(this.config.getStreamReplaySince()));
        }
        streamStub.statusStream(subscribeBuilder.build(), (StreamObserver)observer);
    }
}

