/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.SagaCredentialsFactory;
import games.mythical.saga.sdk.client.SagaCurrencyClient;
import games.mythical.saga.sdk.client.SagaCurrencyTypeClient;
import games.mythical.saga.sdk.client.SagaItemClient;
import games.mythical.saga.sdk.client.SagaItemTypeClient;
import games.mythical.saga.sdk.client.SagaMetadataClient;
import games.mythical.saga.sdk.client.SagaPlayerWalletClient;
import games.mythical.saga.sdk.client.SagaReservationClient;
import games.mythical.saga.sdk.client.executor.SagaCurrencyExecutor;
import games.mythical.saga.sdk.client.executor.SagaItemExecutor;
import games.mythical.saga.sdk.client.executor.SagaItemTypeExecutor;
import games.mythical.saga.sdk.client.executor.SagaMetadataExecutor;
import games.mythical.saga.sdk.client.executor.SagaPlayerWalletExecutor;
import games.mythical.saga.sdk.client.executor.SagaReservationExecutor;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaErrorCode;
import games.mythical.saga.sdk.exception.SagaException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaClientFactory {
    private static final Logger log = LoggerFactory.getLogger(SagaClientFactory.class);
    static final List<String> ALLOWED_UNENCRYPTED_HOSTS = List.of("localhost", "saga-gateway");
    private static SagaClientFactory instance;
    private final SagaSdkConfig config;

    private SagaClientFactory(SagaSdkConfig config) throws SagaException {
        this.config = config;
        SagaCredentialsFactory.initialize(config);
    }

    public static SagaClientFactory getInstance() throws SagaException {
        if (instance == null) {
            log.error("Tried to get uninitialized Client Factory instance");
            throw new SagaException(SagaErrorCode.FACTORY_NOT_INITIALIZED);
        }
        return instance;
    }

    public static SagaClientFactory initialize(SagaSdkConfig config) throws SagaException {
        if (config.isAuthenticated() && instance != null) {
            log.error("Tried to re-initialize Factory.");
            throw new SagaException(SagaErrorCode.REINITIALIZATION_ATTEMPTED);
        }
        SagaClientFactory.validateConfig(config);
        instance = new SagaClientFactory(config);
        return instance;
    }

    private static void validateConfig(SagaSdkConfig config) throws SagaException {
        if (StringUtils.isBlank((CharSequence)config.getTitleId())) {
            throw new SagaException(SagaErrorCode.TITLE_ID_NOT_SET, "Title Id not set!");
        }
        if (StringUtils.isBlank((CharSequence)config.getTitleSecret())) {
            throw new SagaException(SagaErrorCode.TITLE_SECRET_NOT_SET, "Title Secret not set!");
        }
        if (StringUtils.isBlank((CharSequence)config.getAuthUrl())) {
            throw new SagaException(SagaErrorCode.AUTH_URL_NOT_SET, "Authorization Url not set!");
        }
        if (StringUtils.isBlank((CharSequence)config.getHost())) {
            throw new SagaException(SagaErrorCode.HOST_NOT_SET, "Host not set!");
        }
        if (config.getPort() < 1 || config.getPort() > 65535) {
            throw new SagaException(SagaErrorCode.INVALID_PORT, "Invalid port number: " + config.getPort());
        }
        if (config.getKeepAlive() < 0) {
            throw new SagaException(SagaErrorCode.INVALID_KEEP_ALIVE, "Invalid keep alive value: " + config.getKeepAlive());
        }
        if (config.getTokenRefresh() < 5) {
            throw new SagaException(SagaErrorCode.INVALID_TOKEN_REFRESH, "Invalid token refresh value: " + config.getTokenRefresh());
        }
        if (config.isPlainText() && !ALLOWED_UNENCRYPTED_HOSTS.contains(config.getHost())) {
            throw new SagaException(SagaErrorCode.NON_LOCAL_PLAIN_TEXT, "Plain text connection can only be used for allowed hosts: " + ALLOWED_UNENCRYPTED_HOSTS);
        }
    }

    public SagaMetadataClient createSagaMetadataClient() throws SagaException {
        return new SagaMetadataClient(this.config);
    }

    public SagaMetadataClient createSagaMetadataClient(SagaMetadataExecutor executor) throws SagaException {
        return new SagaMetadataClient(this.config, executor);
    }

    public SagaItemClient createSagaItemClient() throws SagaException {
        return new SagaItemClient(this.config);
    }

    public SagaItemClient createSagaItemClient(SagaItemExecutor executor) throws SagaException {
        return new SagaItemClient(this.config, executor);
    }

    public SagaItemTypeClient createSagaItemTypeClient() throws SagaException {
        return new SagaItemTypeClient(this.config);
    }

    public SagaItemTypeClient createSagaItemTypeClient(SagaItemTypeExecutor executor) throws SagaException {
        return new SagaItemTypeClient(this.config, executor);
    }

    public SagaCurrencyClient createSagaCurrencyClient() throws SagaException {
        return new SagaCurrencyClient(this.config);
    }

    public SagaCurrencyClient createSagaCurrencyClient(SagaCurrencyExecutor executor) throws SagaException {
        return new SagaCurrencyClient(this.config, executor);
    }

    public SagaCurrencyTypeClient createSagaCurrencyTypeClient() throws SagaException {
        return new SagaCurrencyTypeClient(this.config);
    }

    public SagaPlayerWalletClient createSagaPlayerWalletClient() throws SagaException {
        return new SagaPlayerWalletClient(this.config);
    }

    public SagaPlayerWalletClient createSagaPlayerWalletClient(SagaPlayerWalletExecutor executor) throws SagaException {
        return new SagaPlayerWalletClient(this.config, executor);
    }

    public SagaReservationClient createSagaReservationClient() throws SagaException {
        return new SagaReservationClient(this.config);
    }

    public SagaReservationClient createSagaReservationClient(SagaReservationExecutor executor) throws SagaException {
        return new SagaReservationClient(this.config, executor);
    }
}

