/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.AbstractSagaStreamClient;
import games.mythical.saga.sdk.client.executor.SagaCurrencyExecutor;
import games.mythical.saga.sdk.client.model.SagaCurrency;
import games.mythical.saga.sdk.client.observer.SagaStatusUpdateObserver;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaErrorCode;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.proto.api.currency.BurnCurrencyRequest;
import games.mythical.saga.sdk.proto.api.currency.CurrencyProto;
import games.mythical.saga.sdk.proto.api.currency.CurrencyServiceGrpc;
import games.mythical.saga.sdk.proto.api.currency.GetCurrencyForPlayerRequest;
import games.mythical.saga.sdk.proto.api.currency.IssueCurrencyRequest;
import games.mythical.saga.sdk.proto.api.currency.TransferCurrencyRequest;
import games.mythical.saga.sdk.proto.common.ReceivedResponse;
import games.mythical.saga.sdk.util.ValidateUtil;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaCurrencyClient
extends AbstractSagaStreamClient {
    private static final Logger log = LoggerFactory.getLogger(SagaCurrencyClient.class);
    private final SagaCurrencyExecutor executor;
    private CurrencyServiceGrpc.CurrencyServiceBlockingStub serviceBlockingStub;

    SagaCurrencyClient(SagaSdkConfig config) throws SagaException {
        this(config, null);
    }

    SagaCurrencyClient(SagaSdkConfig config, SagaCurrencyExecutor executor) throws SagaException {
        super(config);
        this.executor = executor;
        this.initStub();
    }

    @Override
    void initStub() {
        this.serviceBlockingStub = (CurrencyServiceGrpc.CurrencyServiceBlockingStub)CurrencyServiceGrpc.newBlockingStub((Channel)this.channel).withCallCredentials(this.addAuthentication());
        this.initStreamStub();
        SagaStatusUpdateObserver.getInstance().with(this.executor);
    }

    public SagaCurrency getCurrency(String currencyId, String oauthId) throws SagaException {
        GetCurrencyForPlayerRequest request = GetCurrencyForPlayerRequest.newBuilder().setCurrencyTypeId(currencyId).setOauthId(oauthId).build();
        try {
            CurrencyProto currency = this.serviceBlockingStub.getCurrencyForPlayer(request);
            ValidateUtil.checkFound(currency, String.format("Unable to find currency %s for player %s", currencyId, oauthId), new Object[0]);
            return SagaCurrency.fromProto(currency);
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }

    public String issueCurrency(String currencyTypeId, String oauthId, long amount) throws SagaException {
        IssueCurrencyRequest request = IssueCurrencyRequest.newBuilder().setCurrencyTypeId(currencyTypeId).setOauthId(oauthId).setAmount(amount).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.issueCurrency(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on issueCurrency, coin may be lost!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String transferCurrency(String currencyId, String sourceOauthId, String destOauthId, long amount) throws SagaException {
        TransferCurrencyRequest request = TransferCurrencyRequest.newBuilder().setCurrencyId(currencyId).setSourceOauthId(sourceOauthId).setDestinationOauthId(destOauthId).setAmount(amount).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.transferCurrency(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on transferCurrency, coin may be out of sync!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String burnCurrency(String currencyId, String oauthId, long amount) throws SagaException {
        BurnCurrencyRequest request = BurnCurrencyRequest.newBuilder().setCurrencyId(currencyId).setOauthId(oauthId).setAmount(amount).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.burnCurrency(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on burnCurrency, coin may be out of sync!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }
}

