/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client;

import games.mythical.saga.sdk.client.AbstractSagaStreamClient;
import games.mythical.saga.sdk.client.executor.SagaItemExecutor;
import games.mythical.saga.sdk.client.model.SagaIssueItem;
import games.mythical.saga.sdk.client.model.SagaItem;
import games.mythical.saga.sdk.client.observer.SagaStatusUpdateObserver;
import games.mythical.saga.sdk.config.SagaSdkConfig;
import games.mythical.saga.sdk.exception.SagaErrorCode;
import games.mythical.saga.sdk.exception.SagaException;
import games.mythical.saga.sdk.factory.CommonFactory;
import games.mythical.saga.sdk.proto.api.item.BurnItemRequest;
import games.mythical.saga.sdk.proto.api.item.DepositItemRequest;
import games.mythical.saga.sdk.proto.api.item.GetItemRequest;
import games.mythical.saga.sdk.proto.api.item.GetItemsForPlayerRequest;
import games.mythical.saga.sdk.proto.api.item.GetItemsRequest;
import games.mythical.saga.sdk.proto.api.item.IssueItemRequest;
import games.mythical.saga.sdk.proto.api.item.ItemProto;
import games.mythical.saga.sdk.proto.api.item.ItemServiceGrpc;
import games.mythical.saga.sdk.proto.api.item.ItemsProto;
import games.mythical.saga.sdk.proto.api.item.TransferItemBulkRequest;
import games.mythical.saga.sdk.proto.api.item.TransferItemRequest;
import games.mythical.saga.sdk.proto.common.Finalized;
import games.mythical.saga.sdk.proto.common.ReceivedResponse;
import games.mythical.saga.sdk.proto.common.SortOrder;
import games.mythical.saga.sdk.proto.common.item.BlockChains;
import games.mythical.saga.sdk.util.ValidateUtil;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaItemClient
extends AbstractSagaStreamClient {
    private static final Logger log = LoggerFactory.getLogger(SagaItemClient.class);
    private final SagaItemExecutor executor;
    private ItemServiceGrpc.ItemServiceBlockingStub serviceBlockingStub;

    SagaItemClient(SagaSdkConfig config) throws SagaException {
        this(config, null);
    }

    SagaItemClient(SagaSdkConfig config, SagaItemExecutor executor) throws SagaException {
        super(config);
        this.executor = executor;
        this.initStub();
    }

    @Override
    void initStub() {
        this.serviceBlockingStub = (ItemServiceGrpc.ItemServiceBlockingStub)ItemServiceGrpc.newBlockingStub((Channel)this.channel).withCallCredentials(this.addAuthentication());
        this.initStreamStub();
        SagaStatusUpdateObserver.getInstance().with(this.executor);
    }

    public SagaItem getItem(String inventoryId) throws SagaException {
        GetItemRequest request = GetItemRequest.newBuilder().setInventoryId(inventoryId).build();
        try {
            ItemProto item = this.serviceBlockingStub.getItem(request);
            ValidateUtil.checkFound(item, String.format("Item %s not found", request.getInventoryId()), new Object[0]);
            return SagaItem.fromProto(item);
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }

    public List<SagaItem> getItems(Finalized finalized, String tokenName, int pageSize, SortOrder sortOrder, Instant createdAtCursor) throws SagaException {
        GetItemsRequest.Builder request = GetItemsRequest.newBuilder().setQueryOptions(CommonFactory.toProto(pageSize, sortOrder, createdAtCursor)).setFinalized(finalized);
        if (StringUtils.isNotBlank((CharSequence)tokenName)) {
            request.setTokenName(tokenName);
        }
        try {
            ItemsProto items = this.serviceBlockingStub.getItems(request.build());
            return items.getItemsList().stream().map(SagaItem::fromProto).collect(Collectors.toList());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus() == Status.NOT_FOUND) {
                return List.of();
            }
            throw SagaException.fromGrpcException(e);
        }
    }

    public List<SagaItem> getItemsForPlayer(String oauthId, int pageSize, SortOrder sortOrder, Instant createdAtCursor) throws SagaException {
        ValidateUtil.notBlank(oauthId, "oauthId is a required value");
        GetItemsForPlayerRequest request = GetItemsForPlayerRequest.newBuilder().setQueryOptions(CommonFactory.toProto(pageSize, sortOrder, createdAtCursor)).setOauthId(oauthId).build();
        try {
            ItemsProto items = this.serviceBlockingStub.getItemsForPlayer(request);
            return items.getItemsList().stream().map(SagaItem::fromProto).collect(Collectors.toList());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus() == Status.NOT_FOUND) {
                return List.of();
            }
            throw SagaException.fromGrpcException(e);
        }
    }

    public String issueItem(List<SagaIssueItem> issueItems, String recipientOauthId, String itemTypeId) throws SagaException {
        List items = issueItems.stream().map(SagaIssueItem::toProto).collect(Collectors.toList());
        IssueItemRequest.Builder builder = IssueItemRequest.newBuilder().addAllItems(items).setItemTypeId(itemTypeId);
        if (StringUtils.isNotBlank((CharSequence)recipientOauthId)) {
            builder.setRecipientOauthId(recipientOauthId);
        }
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.issueItem(builder.build());
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception on issueItem, item may be lost!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String transferItem(String inventoryId, String destOauthId) throws SagaException {
        TransferItemRequest request = TransferItemRequest.newBuilder().setInventoryId(inventoryId).setDestinationOauthId(destOauthId).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.transferItem(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on transferItem, item may be out of sync!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String transferItemBulk(String idempotencyId, String destOauthId, List<String> inventoryIds) throws SagaException {
        TransferItemBulkRequest request = TransferItemBulkRequest.newBuilder().setIdempotencyId(idempotencyId).setDestinationOauthId(destOauthId).addAllInventoryIds(inventoryIds).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.transferItemBulk(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on transferBulkItem, items may be out of sync!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String burnItem(String inventoryId) throws SagaException {
        BurnItemRequest request = BurnItemRequest.newBuilder().setInventoryId(inventoryId).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.burnItem(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
        catch (Exception e) {
            log.error("Exception calling emitReceived on burnItem, item may be out of sync!", (Throwable)e);
            throw new SagaException(SagaErrorCode.LOCAL_EXCEPTION);
        }
    }

    public String depositItem(String inventoryId, String createdBy, String fromAddress, String toAddress, BlockChains fromChain, String transactionId) throws SagaException {
        DepositItemRequest request = DepositItemRequest.newBuilder().setInventoryId(inventoryId).setCreatedBy(createdBy).setFromAddress(fromAddress).setToAddress(toAddress).setFromChain(fromChain).setTransactionId(transactionId).build();
        try {
            ReceivedResponse receivedResponse = this.serviceBlockingStub.depositItem(request);
            return receivedResponse.getTraceId();
        }
        catch (StatusRuntimeException e) {
            throw SagaException.fromGrpcException(e);
        }
    }
}

