/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client.model;

import games.mythical.proto_util.ProtoUtil;
import games.mythical.proto_util.dto.DtoExclude;
import games.mythical.saga.sdk.proto.api.currencytype.CurrencyTypeProto;
import games.mythical.saga.sdk.util.ConversionUtils;
import java.time.Instant;

public class SagaCurrencyType {
    private String traceId;
    private String currencyTypeId;
    private String gameTitleId;
    private String publisherAddress;
    private String name;
    private String symbol;
    private String contractAddress;
    private boolean finalized;
    private long maxSupply;
    @DtoExclude
    private Instant createdAt;
    @DtoExclude
    private Instant updatedAt;

    public static SagaCurrencyType fromProto(CurrencyTypeProto proto) {
        SagaCurrencyType currencyType = (SagaCurrencyType)ProtoUtil.toDto((Object)proto, SagaCurrencyType.class);
        Instant createdAt = ConversionUtils.protoTimestampToInstant(proto.getCreatedAt());
        currencyType.setCreatedAt(createdAt);
        Instant updatedAt = ConversionUtils.protoTimestampToInstant(proto.getUpdatedAt());
        currencyType.setUpdatedAt(updatedAt);
        return currencyType;
    }

    public static SagaCurrencyTypeBuilder builder() {
        return new SagaCurrencyTypeBuilder();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getCurrencyTypeId() {
        return this.currencyTypeId;
    }

    public String getGameTitleId() {
        return this.gameTitleId;
    }

    public String getPublisherAddress() {
        return this.publisherAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public long getMaxSupply() {
        return this.maxSupply;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setCurrencyTypeId(String currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }

    public void setGameTitleId(String gameTitleId) {
        this.gameTitleId = gameTitleId;
    }

    public void setPublisherAddress(String publisherAddress) {
        this.publisherAddress = publisherAddress;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public void setFinalized(boolean finalized) {
        this.finalized = finalized;
    }

    public void setMaxSupply(long maxSupply) {
        this.maxSupply = maxSupply;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SagaCurrencyType)) {
            return false;
        }
        SagaCurrencyType other = (SagaCurrencyType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFinalized() != other.isFinalized()) {
            return false;
        }
        if (this.getMaxSupply() != other.getMaxSupply()) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$currencyTypeId = this.getCurrencyTypeId();
        String other$currencyTypeId = other.getCurrencyTypeId();
        if (this$currencyTypeId == null ? other$currencyTypeId != null : !this$currencyTypeId.equals(other$currencyTypeId)) {
            return false;
        }
        String this$gameTitleId = this.getGameTitleId();
        String other$gameTitleId = other.getGameTitleId();
        if (this$gameTitleId == null ? other$gameTitleId != null : !this$gameTitleId.equals(other$gameTitleId)) {
            return false;
        }
        String this$publisherAddress = this.getPublisherAddress();
        String other$publisherAddress = other.getPublisherAddress();
        if (this$publisherAddress == null ? other$publisherAddress != null : !this$publisherAddress.equals(other$publisherAddress)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SagaCurrencyType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFinalized() ? 79 : 97);
        long $maxSupply = this.getMaxSupply();
        result = result * 59 + (int)($maxSupply >>> 32 ^ $maxSupply);
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $currencyTypeId = this.getCurrencyTypeId();
        result = result * 59 + ($currencyTypeId == null ? 43 : $currencyTypeId.hashCode());
        String $gameTitleId = this.getGameTitleId();
        result = result * 59 + ($gameTitleId == null ? 43 : $gameTitleId.hashCode());
        String $publisherAddress = this.getPublisherAddress();
        result = result * 59 + ($publisherAddress == null ? 43 : $publisherAddress.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    public String toString() {
        return "SagaCurrencyType(traceId=" + this.getTraceId() + ", currencyTypeId=" + this.getCurrencyTypeId() + ", gameTitleId=" + this.getGameTitleId() + ", publisherAddress=" + this.getPublisherAddress() + ", name=" + this.getName() + ", symbol=" + this.getSymbol() + ", contractAddress=" + this.getContractAddress() + ", finalized=" + this.isFinalized() + ", maxSupply=" + this.getMaxSupply() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }

    public SagaCurrencyType(String traceId, String currencyTypeId, String gameTitleId, String publisherAddress, String name, String symbol, String contractAddress, boolean finalized, long maxSupply, Instant createdAt, Instant updatedAt) {
        this.traceId = traceId;
        this.currencyTypeId = currencyTypeId;
        this.gameTitleId = gameTitleId;
        this.publisherAddress = publisherAddress;
        this.name = name;
        this.symbol = symbol;
        this.contractAddress = contractAddress;
        this.finalized = finalized;
        this.maxSupply = maxSupply;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SagaCurrencyType() {
    }

    public static class SagaCurrencyTypeBuilder {
        private String traceId;
        private String currencyTypeId;
        private String gameTitleId;
        private String publisherAddress;
        private String name;
        private String symbol;
        private String contractAddress;
        private boolean finalized;
        private long maxSupply;
        private Instant createdAt;
        private Instant updatedAt;

        SagaCurrencyTypeBuilder() {
        }

        public SagaCurrencyTypeBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public SagaCurrencyTypeBuilder currencyTypeId(String currencyTypeId) {
            this.currencyTypeId = currencyTypeId;
            return this;
        }

        public SagaCurrencyTypeBuilder gameTitleId(String gameTitleId) {
            this.gameTitleId = gameTitleId;
            return this;
        }

        public SagaCurrencyTypeBuilder publisherAddress(String publisherAddress) {
            this.publisherAddress = publisherAddress;
            return this;
        }

        public SagaCurrencyTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SagaCurrencyTypeBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public SagaCurrencyTypeBuilder contractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public SagaCurrencyTypeBuilder finalized(boolean finalized) {
            this.finalized = finalized;
            return this;
        }

        public SagaCurrencyTypeBuilder maxSupply(long maxSupply) {
            this.maxSupply = maxSupply;
            return this;
        }

        public SagaCurrencyTypeBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SagaCurrencyTypeBuilder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SagaCurrencyType build() {
            return new SagaCurrencyType(this.traceId, this.currencyTypeId, this.gameTitleId, this.publisherAddress, this.name, this.symbol, this.contractAddress, this.finalized, this.maxSupply, this.createdAt, this.updatedAt);
        }

        public String toString() {
            return "SagaCurrencyType.SagaCurrencyTypeBuilder(traceId=" + this.traceId + ", currencyTypeId=" + this.currencyTypeId + ", gameTitleId=" + this.gameTitleId + ", publisherAddress=" + this.publisherAddress + ", name=" + this.name + ", symbol=" + this.symbol + ", contractAddress=" + this.contractAddress + ", finalized=" + this.finalized + ", maxSupply=" + this.maxSupply + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

