/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client.model;

import games.mythical.proto_util.ProtoUtil;
import games.mythical.proto_util.dto.DtoExclude;
import games.mythical.saga.sdk.proto.api.item.ItemProto;
import games.mythical.saga.sdk.util.ConversionUtils;
import java.time.Instant;

public class SagaItem {
    private String traceId;
    private String inventoryId;
    private String oauthId;
    private long tokenId;
    private boolean finalized;
    private String blockExplorerUrl;
    private String metadataUrl;
    @DtoExclude
    private Instant createdAt;
    @DtoExclude
    private Instant updatedAt;

    public static SagaItem fromProto(ItemProto proto) {
        SagaItem user = (SagaItem)ProtoUtil.toDto((Object)proto, SagaItem.class);
        Instant createdAt = ConversionUtils.protoTimestampToInstant(proto.getCreatedAt());
        user.setCreatedAt(createdAt);
        Instant updatedAt = ConversionUtils.protoTimestampToInstant(proto.getUpdatedAt());
        user.setUpdatedAt(updatedAt);
        return user;
    }

    public static SagaItemBuilder builder() {
        return new SagaItemBuilder();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public String getOauthId() {
        return this.oauthId;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public String getBlockExplorerUrl() {
        return this.blockExplorerUrl;
    }

    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setOauthId(String oauthId) {
        this.oauthId = oauthId;
    }

    public void setTokenId(long tokenId) {
        this.tokenId = tokenId;
    }

    public void setFinalized(boolean finalized) {
        this.finalized = finalized;
    }

    public void setBlockExplorerUrl(String blockExplorerUrl) {
        this.blockExplorerUrl = blockExplorerUrl;
    }

    public void setMetadataUrl(String metadataUrl) {
        this.metadataUrl = metadataUrl;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SagaItem)) {
            return false;
        }
        SagaItem other = (SagaItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTokenId() != other.getTokenId()) {
            return false;
        }
        if (this.isFinalized() != other.isFinalized()) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$inventoryId = this.getInventoryId();
        String other$inventoryId = other.getInventoryId();
        if (this$inventoryId == null ? other$inventoryId != null : !this$inventoryId.equals(other$inventoryId)) {
            return false;
        }
        String this$oauthId = this.getOauthId();
        String other$oauthId = other.getOauthId();
        if (this$oauthId == null ? other$oauthId != null : !this$oauthId.equals(other$oauthId)) {
            return false;
        }
        String this$blockExplorerUrl = this.getBlockExplorerUrl();
        String other$blockExplorerUrl = other.getBlockExplorerUrl();
        if (this$blockExplorerUrl == null ? other$blockExplorerUrl != null : !this$blockExplorerUrl.equals(other$blockExplorerUrl)) {
            return false;
        }
        String this$metadataUrl = this.getMetadataUrl();
        String other$metadataUrl = other.getMetadataUrl();
        if (this$metadataUrl == null ? other$metadataUrl != null : !this$metadataUrl.equals(other$metadataUrl)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SagaItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $tokenId = this.getTokenId();
        result = result * 59 + (int)($tokenId >>> 32 ^ $tokenId);
        result = result * 59 + (this.isFinalized() ? 79 : 97);
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $inventoryId = this.getInventoryId();
        result = result * 59 + ($inventoryId == null ? 43 : $inventoryId.hashCode());
        String $oauthId = this.getOauthId();
        result = result * 59 + ($oauthId == null ? 43 : $oauthId.hashCode());
        String $blockExplorerUrl = this.getBlockExplorerUrl();
        result = result * 59 + ($blockExplorerUrl == null ? 43 : $blockExplorerUrl.hashCode());
        String $metadataUrl = this.getMetadataUrl();
        result = result * 59 + ($metadataUrl == null ? 43 : $metadataUrl.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    public String toString() {
        return "SagaItem(traceId=" + this.getTraceId() + ", inventoryId=" + this.getInventoryId() + ", oauthId=" + this.getOauthId() + ", tokenId=" + this.getTokenId() + ", finalized=" + this.isFinalized() + ", blockExplorerUrl=" + this.getBlockExplorerUrl() + ", metadataUrl=" + this.getMetadataUrl() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }

    public SagaItem(String traceId, String inventoryId, String oauthId, long tokenId, boolean finalized, String blockExplorerUrl, String metadataUrl, Instant createdAt, Instant updatedAt) {
        this.traceId = traceId;
        this.inventoryId = inventoryId;
        this.oauthId = oauthId;
        this.tokenId = tokenId;
        this.finalized = finalized;
        this.blockExplorerUrl = blockExplorerUrl;
        this.metadataUrl = metadataUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SagaItem() {
    }

    public static class SagaItemBuilder {
        private String traceId;
        private String inventoryId;
        private String oauthId;
        private long tokenId;
        private boolean finalized;
        private String blockExplorerUrl;
        private String metadataUrl;
        private Instant createdAt;
        private Instant updatedAt;

        SagaItemBuilder() {
        }

        public SagaItemBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public SagaItemBuilder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public SagaItemBuilder oauthId(String oauthId) {
            this.oauthId = oauthId;
            return this;
        }

        public SagaItemBuilder tokenId(long tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public SagaItemBuilder finalized(boolean finalized) {
            this.finalized = finalized;
            return this;
        }

        public SagaItemBuilder blockExplorerUrl(String blockExplorerUrl) {
            this.blockExplorerUrl = blockExplorerUrl;
            return this;
        }

        public SagaItemBuilder metadataUrl(String metadataUrl) {
            this.metadataUrl = metadataUrl;
            return this;
        }

        public SagaItemBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SagaItemBuilder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SagaItem build() {
            return new SagaItem(this.traceId, this.inventoryId, this.oauthId, this.tokenId, this.finalized, this.blockExplorerUrl, this.metadataUrl, this.createdAt, this.updatedAt);
        }

        public String toString() {
            return "SagaItem.SagaItemBuilder(traceId=" + this.traceId + ", inventoryId=" + this.inventoryId + ", oauthId=" + this.oauthId + ", tokenId=" + this.tokenId + ", finalized=" + this.finalized + ", blockExplorerUrl=" + this.blockExplorerUrl + ", metadataUrl=" + this.metadataUrl + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

