/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client.model;

import games.mythical.proto_util.ProtoUtil;
import games.mythical.proto_util.dto.DtoExclude;
import games.mythical.saga.sdk.proto.api.itemtype.ItemTypeProto;
import games.mythical.saga.sdk.util.ConversionUtils;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class SagaItemType {
    private String traceId;
    private String itemTypeId;
    private String name;
    private String symbol;
    private long maxSupply;
    private long issuedSupply;
    private long totalSupply;
    @DtoExclude
    private Long availableSupply;
    private String contractAddress;
    private String blockExplorerUrl;
    private boolean finalized;
    private boolean withdrawable;
    @DtoExclude
    private Instant createdAt;
    @DtoExclude
    private Instant updatedAt;
    private boolean mintable;
    private boolean mintEnded;
    private boolean randomize;

    public static SagaItemType fromProto(ItemTypeProto proto) {
        SagaItemType itemType = (SagaItemType)ProtoUtil.toDto((Object)proto, SagaItemType.class);
        Instant createdAt = ConversionUtils.protoTimestampToInstant(proto.getCreatedAt());
        itemType.setCreatedAt(createdAt);
        Instant updatedAt = ConversionUtils.protoTimestampToInstant(proto.getUpdatedAt());
        itemType.setUpdatedAt(updatedAt);
        if (proto.hasAvailableSupply()) {
            itemType.setAvailableSupply(proto.getAvailableSupply().getValue());
        }
        return itemType;
    }

    public static List<SagaItemType> fromProto(List<ItemTypeProto> protos) {
        return protos.stream().map(SagaItemType::fromProto).collect(Collectors.toList());
    }

    public static SagaItemTypeBuilder builder() {
        return new SagaItemTypeBuilder();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getItemTypeId() {
        return this.itemTypeId;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public long getMaxSupply() {
        return this.maxSupply;
    }

    public long getIssuedSupply() {
        return this.issuedSupply;
    }

    public long getTotalSupply() {
        return this.totalSupply;
    }

    public Long getAvailableSupply() {
        return this.availableSupply;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getBlockExplorerUrl() {
        return this.blockExplorerUrl;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public boolean isWithdrawable() {
        return this.withdrawable;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean isMintable() {
        return this.mintable;
    }

    public boolean isMintEnded() {
        return this.mintEnded;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setItemTypeId(String itemTypeId) {
        this.itemTypeId = itemTypeId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setMaxSupply(long maxSupply) {
        this.maxSupply = maxSupply;
    }

    public void setIssuedSupply(long issuedSupply) {
        this.issuedSupply = issuedSupply;
    }

    public void setTotalSupply(long totalSupply) {
        this.totalSupply = totalSupply;
    }

    public void setAvailableSupply(Long availableSupply) {
        this.availableSupply = availableSupply;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public void setBlockExplorerUrl(String blockExplorerUrl) {
        this.blockExplorerUrl = blockExplorerUrl;
    }

    public void setFinalized(boolean finalized) {
        this.finalized = finalized;
    }

    public void setWithdrawable(boolean withdrawable) {
        this.withdrawable = withdrawable;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setMintable(boolean mintable) {
        this.mintable = mintable;
    }

    public void setMintEnded(boolean mintEnded) {
        this.mintEnded = mintEnded;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SagaItemType)) {
            return false;
        }
        SagaItemType other = (SagaItemType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxSupply() != other.getMaxSupply()) {
            return false;
        }
        if (this.getIssuedSupply() != other.getIssuedSupply()) {
            return false;
        }
        if (this.getTotalSupply() != other.getTotalSupply()) {
            return false;
        }
        if (this.isFinalized() != other.isFinalized()) {
            return false;
        }
        if (this.isWithdrawable() != other.isWithdrawable()) {
            return false;
        }
        if (this.isMintable() != other.isMintable()) {
            return false;
        }
        if (this.isMintEnded() != other.isMintEnded()) {
            return false;
        }
        if (this.isRandomize() != other.isRandomize()) {
            return false;
        }
        Long this$availableSupply = this.getAvailableSupply();
        Long other$availableSupply = other.getAvailableSupply();
        if (this$availableSupply == null ? other$availableSupply != null : !((Object)this$availableSupply).equals(other$availableSupply)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$itemTypeId = this.getItemTypeId();
        String other$itemTypeId = other.getItemTypeId();
        if (this$itemTypeId == null ? other$itemTypeId != null : !this$itemTypeId.equals(other$itemTypeId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) {
            return false;
        }
        String this$blockExplorerUrl = this.getBlockExplorerUrl();
        String other$blockExplorerUrl = other.getBlockExplorerUrl();
        if (this$blockExplorerUrl == null ? other$blockExplorerUrl != null : !this$blockExplorerUrl.equals(other$blockExplorerUrl)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SagaItemType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxSupply = this.getMaxSupply();
        result = result * 59 + (int)($maxSupply >>> 32 ^ $maxSupply);
        long $issuedSupply = this.getIssuedSupply();
        result = result * 59 + (int)($issuedSupply >>> 32 ^ $issuedSupply);
        long $totalSupply = this.getTotalSupply();
        result = result * 59 + (int)($totalSupply >>> 32 ^ $totalSupply);
        result = result * 59 + (this.isFinalized() ? 79 : 97);
        result = result * 59 + (this.isWithdrawable() ? 79 : 97);
        result = result * 59 + (this.isMintable() ? 79 : 97);
        result = result * 59 + (this.isMintEnded() ? 79 : 97);
        result = result * 59 + (this.isRandomize() ? 79 : 97);
        Long $availableSupply = this.getAvailableSupply();
        result = result * 59 + ($availableSupply == null ? 43 : ((Object)$availableSupply).hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $itemTypeId = this.getItemTypeId();
        result = result * 59 + ($itemTypeId == null ? 43 : $itemTypeId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        String $blockExplorerUrl = this.getBlockExplorerUrl();
        result = result * 59 + ($blockExplorerUrl == null ? 43 : $blockExplorerUrl.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    public String toString() {
        return "SagaItemType(traceId=" + this.getTraceId() + ", itemTypeId=" + this.getItemTypeId() + ", name=" + this.getName() + ", symbol=" + this.getSymbol() + ", maxSupply=" + this.getMaxSupply() + ", issuedSupply=" + this.getIssuedSupply() + ", totalSupply=" + this.getTotalSupply() + ", availableSupply=" + this.getAvailableSupply() + ", contractAddress=" + this.getContractAddress() + ", blockExplorerUrl=" + this.getBlockExplorerUrl() + ", finalized=" + this.isFinalized() + ", withdrawable=" + this.isWithdrawable() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", mintable=" + this.isMintable() + ", mintEnded=" + this.isMintEnded() + ", randomize=" + this.isRandomize() + ")";
    }

    public SagaItemType(String traceId, String itemTypeId, String name, String symbol, long maxSupply, long issuedSupply, long totalSupply, Long availableSupply, String contractAddress, String blockExplorerUrl, boolean finalized, boolean withdrawable, Instant createdAt, Instant updatedAt, boolean mintable, boolean mintEnded, boolean randomize) {
        this.traceId = traceId;
        this.itemTypeId = itemTypeId;
        this.name = name;
        this.symbol = symbol;
        this.maxSupply = maxSupply;
        this.issuedSupply = issuedSupply;
        this.totalSupply = totalSupply;
        this.availableSupply = availableSupply;
        this.contractAddress = contractAddress;
        this.blockExplorerUrl = blockExplorerUrl;
        this.finalized = finalized;
        this.withdrawable = withdrawable;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.mintable = mintable;
        this.mintEnded = mintEnded;
        this.randomize = randomize;
    }

    public SagaItemType() {
    }

    public static class SagaItemTypeBuilder {
        private String traceId;
        private String itemTypeId;
        private String name;
        private String symbol;
        private long maxSupply;
        private long issuedSupply;
        private long totalSupply;
        private Long availableSupply;
        private String contractAddress;
        private String blockExplorerUrl;
        private boolean finalized;
        private boolean withdrawable;
        private Instant createdAt;
        private Instant updatedAt;
        private boolean mintable;
        private boolean mintEnded;
        private boolean randomize;

        SagaItemTypeBuilder() {
        }

        public SagaItemTypeBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public SagaItemTypeBuilder itemTypeId(String itemTypeId) {
            this.itemTypeId = itemTypeId;
            return this;
        }

        public SagaItemTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SagaItemTypeBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public SagaItemTypeBuilder maxSupply(long maxSupply) {
            this.maxSupply = maxSupply;
            return this;
        }

        public SagaItemTypeBuilder issuedSupply(long issuedSupply) {
            this.issuedSupply = issuedSupply;
            return this;
        }

        public SagaItemTypeBuilder totalSupply(long totalSupply) {
            this.totalSupply = totalSupply;
            return this;
        }

        public SagaItemTypeBuilder availableSupply(Long availableSupply) {
            this.availableSupply = availableSupply;
            return this;
        }

        public SagaItemTypeBuilder contractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public SagaItemTypeBuilder blockExplorerUrl(String blockExplorerUrl) {
            this.blockExplorerUrl = blockExplorerUrl;
            return this;
        }

        public SagaItemTypeBuilder finalized(boolean finalized) {
            this.finalized = finalized;
            return this;
        }

        public SagaItemTypeBuilder withdrawable(boolean withdrawable) {
            this.withdrawable = withdrawable;
            return this;
        }

        public SagaItemTypeBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SagaItemTypeBuilder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SagaItemTypeBuilder mintable(boolean mintable) {
            this.mintable = mintable;
            return this;
        }

        public SagaItemTypeBuilder mintEnded(boolean mintEnded) {
            this.mintEnded = mintEnded;
            return this;
        }

        public SagaItemTypeBuilder randomize(boolean randomize) {
            this.randomize = randomize;
            return this;
        }

        public SagaItemType build() {
            return new SagaItemType(this.traceId, this.itemTypeId, this.name, this.symbol, this.maxSupply, this.issuedSupply, this.totalSupply, this.availableSupply, this.contractAddress, this.blockExplorerUrl, this.finalized, this.withdrawable, this.createdAt, this.updatedAt, this.mintable, this.mintEnded, this.randomize);
        }

        public String toString() {
            return "SagaItemType.SagaItemTypeBuilder(traceId=" + this.traceId + ", itemTypeId=" + this.itemTypeId + ", name=" + this.name + ", symbol=" + this.symbol + ", maxSupply=" + this.maxSupply + ", issuedSupply=" + this.issuedSupply + ", totalSupply=" + this.totalSupply + ", availableSupply=" + this.availableSupply + ", contractAddress=" + this.contractAddress + ", blockExplorerUrl=" + this.blockExplorerUrl + ", finalized=" + this.finalized + ", withdrawable=" + this.withdrawable + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", mintable=" + this.mintable + ", mintEnded=" + this.mintEnded + ", randomize=" + this.randomize + ")";
        }
    }
}

