/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client.model;

import games.mythical.proto_util.ProtoUtil;
import games.mythical.proto_util.dto.DtoExclude;
import games.mythical.saga.sdk.proto.api.playerwallet.PlayerWalletProto;
import games.mythical.saga.sdk.util.ConversionUtils;
import java.time.Instant;

public class SagaPlayerWallet {
    private String traceId;
    private String oauthId;
    private String address;
    private String balanceInWei;
    @DtoExclude
    private Instant createdAt;
    @DtoExclude
    private Instant updatedAt;

    public static SagaPlayerWallet fromProto(PlayerWalletProto proto) {
        SagaPlayerWallet playerwallet = (SagaPlayerWallet)ProtoUtil.toDto((Object)proto, SagaPlayerWallet.class);
        Instant createdAt = ConversionUtils.protoTimestampToInstant(proto.getCreatedAt());
        playerwallet.setCreatedAt(createdAt);
        Instant updatedAt = ConversionUtils.protoTimestampToInstant(proto.getUpdatedAt());
        playerwallet.setUpdatedAt(updatedAt);
        return playerwallet;
    }

    public static SagaPlayerWalletBuilder builder() {
        return new SagaPlayerWalletBuilder();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getOauthId() {
        return this.oauthId;
    }

    public String getAddress() {
        return this.address;
    }

    public String getBalanceInWei() {
        return this.balanceInWei;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setOauthId(String oauthId) {
        this.oauthId = oauthId;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setBalanceInWei(String balanceInWei) {
        this.balanceInWei = balanceInWei;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SagaPlayerWallet)) {
            return false;
        }
        SagaPlayerWallet other = (SagaPlayerWallet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$oauthId = this.getOauthId();
        String other$oauthId = other.getOauthId();
        if (this$oauthId == null ? other$oauthId != null : !this$oauthId.equals(other$oauthId)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$balanceInWei = this.getBalanceInWei();
        String other$balanceInWei = other.getBalanceInWei();
        if (this$balanceInWei == null ? other$balanceInWei != null : !this$balanceInWei.equals(other$balanceInWei)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SagaPlayerWallet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $oauthId = this.getOauthId();
        result = result * 59 + ($oauthId == null ? 43 : $oauthId.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $balanceInWei = this.getBalanceInWei();
        result = result * 59 + ($balanceInWei == null ? 43 : $balanceInWei.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    public String toString() {
        return "SagaPlayerWallet(traceId=" + this.getTraceId() + ", oauthId=" + this.getOauthId() + ", address=" + this.getAddress() + ", balanceInWei=" + this.getBalanceInWei() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }

    public SagaPlayerWallet(String traceId, String oauthId, String address, String balanceInWei, Instant createdAt, Instant updatedAt) {
        this.traceId = traceId;
        this.oauthId = oauthId;
        this.address = address;
        this.balanceInWei = balanceInWei;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SagaPlayerWallet() {
    }

    public static class SagaPlayerWalletBuilder {
        private String traceId;
        private String oauthId;
        private String address;
        private String balanceInWei;
        private Instant createdAt;
        private Instant updatedAt;

        SagaPlayerWalletBuilder() {
        }

        public SagaPlayerWalletBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public SagaPlayerWalletBuilder oauthId(String oauthId) {
            this.oauthId = oauthId;
            return this;
        }

        public SagaPlayerWalletBuilder address(String address) {
            this.address = address;
            return this;
        }

        public SagaPlayerWalletBuilder balanceInWei(String balanceInWei) {
            this.balanceInWei = balanceInWei;
            return this;
        }

        public SagaPlayerWalletBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SagaPlayerWalletBuilder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SagaPlayerWallet build() {
            return new SagaPlayerWallet(this.traceId, this.oauthId, this.address, this.balanceInWei, this.createdAt, this.updatedAt);
        }

        public String toString() {
            return "SagaPlayerWallet.SagaPlayerWalletBuilder(traceId=" + this.traceId + ", oauthId=" + this.oauthId + ", address=" + this.address + ", balanceInWei=" + this.balanceInWei + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

