/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.client.observer;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObserver<V>
implements StreamObserver<V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractObserver.class);
    private static final int MAX_COUNT = 16;
    private boolean retry = false;
    private int requestCount = 1;

    protected void sleepBetweenReconnects() {
        if (!this.retry) {
            this.retry = true;
            return;
        }
        int sleepTimeMillis = (int)Math.pow(2.0, this.requestCount) + RandomUtils.nextInt((int)1, (int)1000);
        try {
            log.trace("Sleeping {} milliseconds before reconnect", (Object)sleepTimeMillis);
            TimeUnit.MILLISECONDS.sleep(sleepTimeMillis);
            if (this.requestCount < 16) {
                ++this.requestCount;
            }
        }
        catch (InterruptedException e) {
            log.error("Retry interrupted, exiting...");
            Thread.currentThread().interrupt();
        }
    }

    protected void resetConnectionRetry() {
        this.retry = false;
        this.requestCount = 1;
    }
}

