/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.saga.sdk.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import games.mythical.saga.sdk.exception.ErrorData;
import games.mythical.saga.sdk.exception.SagaErrorCode;
import games.mythical.saga.sdk.proto.api.common.ErrorProto;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(SagaException.class);
    private static final ObjectMapper objMapper = new ObjectMapper();
    private final ErrorData errorData;

    public SagaException(ErrorData errorData) {
        super(errorData.getMessage());
        this.errorData = errorData;
    }

    public SagaException(SagaErrorCode errorCode) {
        this(errorCode, errorCode.toString());
    }

    public SagaException(SagaErrorCode errorCode, String message) {
        super(message);
        this.errorData = ErrorData.builder().code(errorCode.toString()).message(message).build();
    }

    public ErrorData getErrorData() {
        return this.errorData;
    }

    public static SagaException fromGrpcException(StatusException ex) {
        return SagaException.fromGrpcException(ex.getStatus().getCode(), (Exception)ex);
    }

    public static SagaException fromGrpcException(StatusRuntimeException ex) {
        return SagaException.fromGrpcException(ex.getStatus().getCode(), (Exception)ex);
    }

    private static SagaException fromGrpcException(Status.Code code, Exception ex) {
        try {
            Status status = StatusProto.fromThrowable((Throwable)ex);
            List details = status.getDetailsList();
            if (details.isEmpty()) {
                return new SagaException(SagaException.toSagaErrorCode(Status.Code.INTERNAL), ex.getMessage());
            }
            ErrorProto errorProto = (ErrorProto)((Any)details.get(0)).unpack(ErrorProto.class);
            ErrorData errorData = ErrorData.builder().code(SagaException.toSagaErrorCode(code).toString()).source(errorProto.getSource()).message(errorProto.getMessage()).trace(errorProto.getTraceId()).build();
            return new SagaException(errorData);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Exception when trying to create SagaException {}", (Throwable)e);
            return new SagaException(SagaException.toSagaErrorCode(Status.Code.INTERNAL), ex.getMessage());
        }
    }

    private static SagaErrorCode toSagaErrorCode(Status.Code grpcCode) {
        switch (grpcCode) {
            case INVALID_ARGUMENT: {
                return SagaErrorCode.INVALID_ARGUMENT;
            }
            case NOT_FOUND: {
                return SagaErrorCode.NOT_FOUND;
            }
            case PERMISSION_DENIED: {
                return SagaErrorCode.PERMISSION_DENIED;
            }
            case UNIMPLEMENTED: {
                return SagaErrorCode.UNIMPLEMENTED;
            }
            case UNAUTHENTICATED: {
                return SagaErrorCode.UNAUTHENTICATED;
            }
            case UNAVAILABLE: {
                return SagaErrorCode.UNAVAILABLE;
            }
            case RESOURCE_EXHAUSTED: {
                return SagaErrorCode.RESOURCE_EXHAUSTED;
            }
            case ABORTED: {
                return SagaErrorCode.ABORTED;
            }
            case DEADLINE_EXCEEDED: 
            case FAILED_PRECONDITION: 
            case OUT_OF_RANGE: {
                return SagaErrorCode.BAD_REQUEST;
            }
            case ALREADY_EXISTS: {
                return SagaErrorCode.CONFLICT;
            }
            case DATA_LOSS: 
            case INTERNAL: 
            case UNKNOWN: {
                return SagaErrorCode.SERVER_ERROR;
            }
        }
        return SagaErrorCode.UNKNOWN_GRPC_ERROR;
    }
}

