package gg.gamerewards;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import gg.gamerewards.data.api.ApiRepository;
import gg.gamerewards.data.api.ApiService;
import gg.gamerewards.data.local.PrefManager;
import gg.gamerewards.di.ApiModule;
import gg.gamerewards.di.ApiModule_ProvideApiServiceFactory;
import gg.gamerewards.di.ApiModule_ProvideRetrofitFactory;
import gg.gamerewards.di.ApiModule_ProvidesHttpLoggingInterceptorFactory;
import gg.gamerewards.di.ApiModule_ProvidesOkHttpClientFactory;
import gg.gamerewards.di.ApiModule_ProvidesRepositoryFactory;
import gg.gamerewards.ui.fragments.gameDetail.GameDetailViewModel;
import gg.gamerewards.ui.fragments.gameDetail.checkPointsSeeAll.CheckPointsSeeAllViewModel;
import gg.gamerewards.ui.fragments.games.GamesViewModel;
import javax.annotation.processing.Generated;
import javax.inject.Provider;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;

@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
public final class DaggerViewModelComponent {
  private DaggerViewModelComponent() {
  }

  public static ViewModelComponent.Factory factory() {
    return new Factory();
  }

  public static ViewModelComponent create() {
    return new Factory().create();
  }

  private static final class Factory implements ViewModelComponent.Factory {
    @Override
    public ViewModelComponent create() {
      return new ViewModelComponentImpl(new RichieModule(), new ApiModule(), new ViewModelProviderModule());
    }
  }

  private static final class ViewModelComponentImpl implements ViewModelComponent {
    private final ViewModelProviderModule viewModelProviderModule;

    private final ApiModule apiModule;

    private final RichieModule richieModule;

    private final ViewModelComponentImpl viewModelComponentImpl = this;

    private Provider<HttpLoggingInterceptor> providesHttpLoggingInterceptorProvider;

    private Provider<PrefManager> providePrefManager$gamerewards_sdk_android_releaseProvider;

    private Provider<OkHttpClient> providesOkHttpClientProvider;

    private Provider<Retrofit> provideRetrofitProvider;

    private Provider<ApiService> provideApiServiceProvider;

    private Provider<ApiRepository> providesRepositoryProvider;

    private Provider<GamesViewModel> provideGamesViewModel$gamerewards_sdk_android_releaseProvider;

    private Provider<RichieViewModel> provideRichieViewModel$gamerewards_sdk_android_releaseProvider;

    private Provider<GameDetailViewModel> provideGameDetailViewModel$gamerewards_sdk_android_releaseProvider;

    private Provider<CheckPointsSeeAllViewModel> provideCheckpointSeeAllViewModel$gamerewards_sdk_android_releaseProvider;

    private Provider<ViewModelProviderInstance> viewModelProviderInstanceProvider;

    private ViewModelComponentImpl(RichieModule richieModuleParam, ApiModule apiModuleParam,
        ViewModelProviderModule viewModelProviderModuleParam) {
      this.viewModelProviderModule = viewModelProviderModuleParam;
      this.apiModule = apiModuleParam;
      this.richieModule = richieModuleParam;
      initialize(richieModuleParam, apiModuleParam, viewModelProviderModuleParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final RichieModule richieModuleParam, final ApiModule apiModuleParam,
        final ViewModelProviderModule viewModelProviderModuleParam) {
      this.providesHttpLoggingInterceptorProvider = DoubleCheck.provider(new SwitchingProvider<HttpLoggingInterceptor>(viewModelComponentImpl, 6));
      this.providePrefManager$gamerewards_sdk_android_releaseProvider = DoubleCheck.provider(new SwitchingProvider<PrefManager>(viewModelComponentImpl, 7));
      this.providesOkHttpClientProvider = DoubleCheck.provider(new SwitchingProvider<OkHttpClient>(viewModelComponentImpl, 5));
      this.provideRetrofitProvider = DoubleCheck.provider(new SwitchingProvider<Retrofit>(viewModelComponentImpl, 4));
      this.provideApiServiceProvider = DoubleCheck.provider(new SwitchingProvider<ApiService>(viewModelComponentImpl, 3));
      this.providesRepositoryProvider = DoubleCheck.provider(new SwitchingProvider<ApiRepository>(viewModelComponentImpl, 2));
      this.provideGamesViewModel$gamerewards_sdk_android_releaseProvider = DoubleCheck.provider(new SwitchingProvider<GamesViewModel>(viewModelComponentImpl, 1));
      this.provideRichieViewModel$gamerewards_sdk_android_releaseProvider = DoubleCheck.provider(new SwitchingProvider<RichieViewModel>(viewModelComponentImpl, 8));
      this.provideGameDetailViewModel$gamerewards_sdk_android_releaseProvider = DoubleCheck.provider(new SwitchingProvider<GameDetailViewModel>(viewModelComponentImpl, 9));
      this.provideCheckpointSeeAllViewModel$gamerewards_sdk_android_releaseProvider = DoubleCheck.provider(new SwitchingProvider<CheckPointsSeeAllViewModel>(viewModelComponentImpl, 10));
      this.viewModelProviderInstanceProvider = DoubleCheck.provider(new SwitchingProvider<ViewModelProviderInstance>(viewModelComponentImpl, 0));
    }

    @Override
    public ViewModelProviderInstance provider() {
      return viewModelProviderInstanceProvider.get();
    }

    private static final class SwitchingProvider<T> implements Provider<T> {
      private final ViewModelComponentImpl viewModelComponentImpl;

      private final int id;

      SwitchingProvider(ViewModelComponentImpl viewModelComponentImpl, int id) {
        this.viewModelComponentImpl = viewModelComponentImpl;
        this.id = id;
      }

      @SuppressWarnings("unchecked")
      @Override
      public T get() {
        switch (id) {
          case 0: // gg.gamerewards.ViewModelProviderInstance 
          return (T) new ViewModelProviderInstance(viewModelComponentImpl.provideGamesViewModel$gamerewards_sdk_android_releaseProvider.get(), viewModelComponentImpl.provideRichieViewModel$gamerewards_sdk_android_releaseProvider.get(), viewModelComponentImpl.provideGameDetailViewModel$gamerewards_sdk_android_releaseProvider.get(), viewModelComponentImpl.provideCheckpointSeeAllViewModel$gamerewards_sdk_android_releaseProvider.get());

          case 1: // gg.gamerewards.ui.fragments.games.GamesViewModel 
          return (T) ViewModelProviderModule_ProvideGamesViewModel$gamerewards_sdk_android_releaseFactory.provideGamesViewModel$gamerewards_sdk_android_release(viewModelComponentImpl.viewModelProviderModule, viewModelComponentImpl.providesRepositoryProvider.get());

          case 2: // gg.gamerewards.data.api.ApiRepository 
          return (T) ApiModule_ProvidesRepositoryFactory.providesRepository(viewModelComponentImpl.apiModule, viewModelComponentImpl.provideApiServiceProvider.get());

          case 3: // gg.gamerewards.data.api.ApiService 
          return (T) ApiModule_ProvideApiServiceFactory.provideApiService(viewModelComponentImpl.apiModule, viewModelComponentImpl.provideRetrofitProvider.get());

          case 4: // retrofit2.Retrofit 
          return (T) ApiModule_ProvideRetrofitFactory.provideRetrofit(viewModelComponentImpl.apiModule, viewModelComponentImpl.providesOkHttpClientProvider.get());

          case 5: // okhttp3.OkHttpClient 
          return (T) ApiModule_ProvidesOkHttpClientFactory.providesOkHttpClient(viewModelComponentImpl.apiModule, viewModelComponentImpl.providesHttpLoggingInterceptorProvider.get(), viewModelComponentImpl.providePrefManager$gamerewards_sdk_android_releaseProvider.get(), RichieModule_ProvideContext$gamerewards_sdk_android_releaseFactory.provideContext$gamerewards_sdk_android_release(viewModelComponentImpl.richieModule));

          case 6: // okhttp3.logging.HttpLoggingInterceptor 
          return (T) ApiModule_ProvidesHttpLoggingInterceptorFactory.providesHttpLoggingInterceptor(viewModelComponentImpl.apiModule);

          case 7: // gg.gamerewards.data.local.PrefManager 
          return (T) RichieModule_ProvidePrefManager$gamerewards_sdk_android_releaseFactory.providePrefManager$gamerewards_sdk_android_release(viewModelComponentImpl.richieModule);

          case 8: // gg.gamerewards.RichieViewModel 
          return (T) ViewModelProviderModule_ProvideRichieViewModel$gamerewards_sdk_android_releaseFactory.provideRichieViewModel$gamerewards_sdk_android_release(viewModelComponentImpl.viewModelProviderModule, viewModelComponentImpl.providesRepositoryProvider.get(), viewModelComponentImpl.providePrefManager$gamerewards_sdk_android_releaseProvider.get());

          case 9: // gg.gamerewards.ui.fragments.gameDetail.GameDetailViewModel 
          return (T) ViewModelProviderModule_ProvideGameDetailViewModel$gamerewards_sdk_android_releaseFactory.provideGameDetailViewModel$gamerewards_sdk_android_release(viewModelComponentImpl.viewModelProviderModule, viewModelComponentImpl.providesRepositoryProvider.get());

          case 10: // gg.gamerewards.ui.fragments.gameDetail.checkPointsSeeAll.CheckPointsSeeAllViewModel 
          return (T) ViewModelProviderModule_ProvideCheckpointSeeAllViewModel$gamerewards_sdk_android_releaseFactory.provideCheckpointSeeAllViewModel$gamerewards_sdk_android_release(viewModelComponentImpl.viewModelProviderModule);

          default: throw new AssertionError(id);
        }
      }
    }
  }
}
