package gg.gamerewards.builder

class RichieParams private constructor(
    val uaNetwork: String,
    val uaChannel: String,
    val uaSubPublisherCleartext: String,
    val uaSubPublisherEncrypted: String,
    val placement: String
) {
    class Builder {
        private var uaNetwork: String = ""
        private var uaChannel: String = ""
        private var uaSubPublisherCleartext: String = ""
        private var uaSubPublisherEncrypted: String = ""
        private var placement: String = ""

        fun setUaNetwork(uaNetwork: String) = apply { this.uaNetwork = uaNetwork }
        fun setUaChannel(uaChannel: String) = apply { this.uaChannel = uaChannel }
        fun setUaSubPublisherCleartext(uaSubPublisherCleartext: String) = apply { this.uaSubPublisherCleartext = uaSubPublisherCleartext }
        fun setUaSubPublisherEncrypted(uaSubPublisherEncrypted: String) = apply { this.uaSubPublisherEncrypted = uaSubPublisherEncrypted }
        fun setPlacement(placement: String) = apply { this.placement = placement }

        fun build() = RichieParams(
            uaNetwork,
            uaChannel,
            uaSubPublisherCleartext,
            uaSubPublisherEncrypted,
            placement
        )
    }

    override fun toString(): String {
        return "RichieParams uaNetwork : $uaNetwork, uaChannel : $uaChannel, uaSubPublisherCleartext : $uaSubPublisherCleartext, uaSubPublisherEncrypted : $uaSubPublisherEncrypted, placement : $placement"
    }
}