package gg.gamerewards.data.api

import gg.gamerewards.data.model.request.ConsumeClaimRequest
import gg.gamerewards.data.model.request.GuestLoginRequest
import gg.gamerewards.data.model.request.PlayTimeEventsRequest
import gg.gamerewards.data.model.response.ClaimResponse
import gg.gamerewards.data.model.response.GetClaimsResponse
import gg.gamerewards.data.model.response.LoginResponse
import gg.gamerewards.data.model.response.OfferDetailResponse
import gg.gamerewards.data.model.response.PlacementResponse
import gg.gamerewards.data.model.response.SystemTimeResponse
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Path
import retrofit2.http.Query

/**
 * Created by Hasan Güler on 18.05.2023.
 */
internal interface ApiService {

    @GET("offer/placementDetails/{placementId}")
    suspend fun getPlacementDetailsByPlacementId(
        @Path("placementId") placementId: String
    ): Response<PlacementResponse>

    @POST("login/guest")
    suspend fun guestLogin(@Body request: GuestLoginRequest): Response<LoginResponse>


    @POST("login/refreshToken")
    suspend fun refreshToken(@Body request: GuestLoginRequest): Response<LoginResponse>

    @GET("offer/claims/history/byDate")
    suspend fun getClaimHistory(@Query("date") lastClaimDate: Long?): Response<GetClaimsResponse>

    @GET("offer/details/{offerKeyId}")
    suspend fun getOfferDetail(
        @Path("offerKeyId") offerKeyId: String,
        @Query("offerGroupTitle") offerGroupTitle: String
    ): Response<OfferDetailResponse>

    @POST("encPlaytimeEvents")
    suspend fun sendPlayTimeEvents(@Body request: PlayTimeEventsRequest?): Response<ClaimResponse>

    @GET("dev/getSystemTime")
    suspend fun getSystemTime(): Response<SystemTimeResponse>

    @POST("claim/consumeClaim")
    suspend fun consumeClaim(@Body request: ConsumeClaimRequest): Response<Any>

    @POST("dashboard/bonusCoin")
    suspend fun giveBonusCoinToUserKeyId(
        @Query("userKeyId") userKeyId: String,
        @Query("rewardCoinAmount") rewardCoinAmount: Int
    ): Response<Any>
}