package gg.gamerewards.data.api

import android.content.Context
import gg.gamerewards.data.local.PrefManager
import gg.gamerewards.utils.isVpnDetected
import okhttp3.Interceptor
import okhttp3.Response

internal class VpnDetectionInterceptor (private val context: Context,private val prefManager: PrefManager) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        if (context.isVpnDetected(prefManager)){
            throw DetectVpnException()
        }
        return chain.proceed(chain.request())
    }
}