package gg.gamerewards.data.model.response

import android.content.Context
import com.google.gson.annotations.SerializedName
import gg.gamerewards.R
import gg.gamerewards.data.model.BaseResponse

/**
 * Created by Hasan Güler on 1.06.2023.
 */
internal data class ProfileResponse(
    @SerializedName("data") val profileData: ProfileData?,
) : BaseResponse()

internal data class ProfileData(
    @SerializedName("id") val id: Int?,
    @SerializedName("invitedUserKeyId") val invitedUserKeyId: String?,
    @SerializedName("userKeyId") val userKeyId: String?,
    @SerializedName("email") val email: String?,
    @SerializedName("username") val username: String?,
    @SerializedName("age") val age: Int?,
    @SerializedName("sex") val gender: Int?,
    @SerializedName("avatarUrl") val avatarUrl: String?,
    @SerializedName("isEmailVerified") val isEmailVerified: Boolean?,
    @SerializedName("isGuest") val isGuest: Boolean?,
    @SerializedName("isActive") val isActive: Boolean?,
    @SerializedName("isAutoOptimizationRewardAvailable") val isAutoOptimizationRewardAvailable: Boolean?,
    @SerializedName("isCompleteProfileRewardAvailable") val isCompleteProfileRewardAvailable: Boolean?,
    @SerializedName("dailyRewardAvailable") val dailyRewardAvailable: Boolean?,
    @SerializedName("coins") val coins: Int?,
    @SerializedName("consecutiveDailyRewardDays") var consecutiveDailyRewardDays: Int?,
    //@SerializedName("history") val historyList: ArrayList<History>?,
    @SerializedName("hasPassword") val hasPassword: Boolean?,
    @SerializedName("isDailyRewardClaimed") val isDailyRewardClaimed: Boolean?,
    @SerializedName("passwordAvailable") var passwordAvailable: Boolean?,
    @SerializedName("numSpins") var numSpins: Int?,
    @SerializedName("numRewardedSpins") var numRewardedSpins: Int?,
    @SerializedName("countryCode") var countryCode: String?,
    @SerializedName("cid") val cid: String?,
    @SerializedName("totalEarnedCoins") val totalEarnedCoins: Long?,
    @SerializedName("isEnforcedVerificationPassed") val isEnforcedVerificationPassed: Boolean?,

) {
    internal fun getDisplayUserName(): String = "@${username ?: ""}"
    internal fun getDisplayEmail(context: Context): String? = if (isGuest == false) email else context.getString(
        R.string.profile_anonymous_user)
    internal fun getDisplayCurrentCoin(): String = (coins ?: 0).toString()

    internal fun getTotalSpinAvailable(): Int = (numSpins ?: 0) + (numRewardedSpins ?: 0)
}
