package gg.gamerewards.di;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import gg.gamerewards.data.api.ApiRepository;
import gg.gamerewards.data.api.ApiService;
import javax.annotation.processing.Generated;
import javax.inject.Provider;

@ScopeMetadata("javax.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
public final class ApiModule_ProvidesRepositoryFactory implements Factory<ApiRepository> {
  private final ApiModule module;

  private final Provider<ApiService> apiServiceProvider;

  public ApiModule_ProvidesRepositoryFactory(ApiModule module,
      Provider<ApiService> apiServiceProvider) {
    this.module = module;
    this.apiServiceProvider = apiServiceProvider;
  }

  @Override
  public ApiRepository get() {
    return providesRepository(module, apiServiceProvider.get());
  }

  public static ApiModule_ProvidesRepositoryFactory create(ApiModule module,
      Provider<ApiService> apiServiceProvider) {
    return new ApiModule_ProvidesRepositoryFactory(module, apiServiceProvider);
  }

  public static ApiRepository providesRepository(ApiModule instance, ApiService apiService) {
    return Preconditions.checkNotNullFromProvides(instance.providesRepository(apiService));
  }
}
