package gg.gamerewards.ui.activities.offerwallActivity

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.os.Handler
import android.provider.Settings
import android.view.LayoutInflater
import androidx.activity.result.contract.ActivityResultContracts
import androidx.navigation.NavController
import androidx.navigation.NavDestination
import androidx.navigation.fragment.NavHostFragment
import gg.gamerewards.R
import gg.gamerewards.ViewModelProvider
import gg.gamerewards.databinding.ActivityOfferwallBinding
import gg.gamerewards.ui.base.BaseActivity
import gg.gamerewards.ui.customView.PermissionsDialog
import gg.gamerewards.ui.fragments.games.GamesFragment
import gg.gamerewards.utils.PermissionManager
import java.net.URI


internal class OfferwallActivity : BaseActivity<ActivityOfferwallBinding>(),NavController.OnDestinationChangedListener,PermissionsDialog.PermissionsDialogImpl {

    override val bindingInflater: (LayoutInflater) -> ActivityOfferwallBinding
        get() = ActivityOfferwallBinding::inflate

    private var navHostFragment: NavHostFragment? = null
    private var navController: NavController? = null
    private var permissionsDialog: PermissionsDialog? = null

    override fun setupUi(savedInstanceState: Bundle?) {
        binding.apply {
            navHostFragment = (supportFragmentManager.findFragmentById(binding.mainHostFragment.id) as NavHostFragment)
            navController = navHostFragment?.navController
            navController?.let { controller ->
                val graph = controller.navInflater.inflate(R.navigation.main_navigation)
                graph.setStartDestination( R.id.gamesFragment)
                controller.graph = graph
            }
            navController?.addOnDestinationChangedListener(this@OfferwallActivity)
        }
        if(!PermissionManager.isUsageStatsPermissionGranted(this)){
            showPermissionDialog(this)
        }
    }



    fun showPermissionDialog(ctx: Context) {
        if (!PermissionManager.areRequiredPermissionsGranted(ctx)) {
            permissionsDialog?.dismiss()
            permissionsDialog = null
            permissionsDialog = PermissionsDialog(ctx, this)
            permissionsDialog?.show()
        }
    }

    fun handleDeeplink(action: String?, clickURL: String?, from: String?, fromTitle: String?) {
        try {
            val deeplinkUri = URI(action)
            val host = deeplinkUri.host
            val paths = deeplinkUri.path.removePrefix("/").split("/")
            val firstPath = paths.getOrNull(0)
            val secondPath = paths.getOrNull(1)

            when (host) {
                "offerDetail" -> {
                    firstPath?.let { offerKeyId ->
                        val extras = Bundle()
                        extras.putString("offerKeyId", offerKeyId)
                        extras.putString("clickUrl", clickURL)
                        extras.putString("from", from)
                        extras.putString("fromTitle", fromTitle)
                        navigate(navController,R.id.gameDetailFragment, "OfferwallActivity", extras = extras)
                    }
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private var checkUsageStatsHandler: Handler = Handler()
    private var checkUsageStatsPermission: Runnable = object : Runnable {
        override fun run() {
            if (PermissionManager.isUsageStatsPermissionGranted(this@OfferwallActivity)) {
                //We have the permission, re-launch
                relaunchActivity()
                return
            }
            //Check every 0.1 second
            checkUsageStatsHandler.postDelayed(this, 100)
        }
    }

    private fun relaunchActivity() {
        val i = Intent(this, OfferwallActivity::class.java)
        i.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP or Intent.FLAG_ACTIVITY_SINGLE_TOP)
        startActivity(i)
    }

    private var usageStatsResultLauncher =
        registerForActivityResult(ActivityResultContracts.StartActivityForResult()) {
            permissionsDialog?.onResume()
        }

    override fun onClickedPermitUsageStatsPermission() {
        val intent = Intent(Settings.ACTION_USAGE_ACCESS_SETTINGS)
        runCatching {
            intent.data = Uri.parse("package:$packageName")
            usageStatsResultLauncher.launch(intent)
        }.onFailure {
            runCatching {
                intent.data = null
                usageStatsResultLauncher.launch(intent)
            }.onFailure {
                runCatching {
                    val settingsIntent = Intent(Settings.ACTION_SECURITY_SETTINGS)
                    settingsIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                    startActivity(settingsIntent)
                }.onFailure {
                }
            }
        }
        checkUsageStatsHandler.post(checkUsageStatsPermission)
    }

    override fun onPermissionDismissed(dismiss: () -> Unit) {
        val viewModel = ViewModelProvider.getInstance().provideRichieViewModel()
        dismiss()
        //TODO
        /*viewModel.postSetAutoOptimizationGiven(this) { isError ->
            if (isError == false)
            dismiss()
        }*/
    }

    override fun onDestinationChanged(
        controller: NavController,
        destination: NavDestination,
        arguments: Bundle?
    ) {
        //TODO("Not yet implemented")
    }

    private fun runIfGamesFragmentActive(onSuccess : (fragment : GamesFragment) -> Unit){
        kotlin.runCatching {
            val navHostFragment = supportFragmentManager.findFragmentById(R.id.mainHostFragment) as NavHostFragment
            val currentFragment = navHostFragment.childFragmentManager.fragments[0]
            if (currentFragment is GamesFragment){
                onSuccess(currentFragment)
            }
        }.onFailure {
            /* no op, just ignore */
        }
    }

}