package gg.gamerewards.ui.base

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.annotation.CallSuper
import androidx.fragment.app.Fragment
import androidx.lifecycle.LifecycleObserver
import androidx.lifecycle.setViewTreeLifecycleOwner
import androidx.navigation.fragment.findNavController
import androidx.viewbinding.ViewBinding
import gg.gamerewards.utils.NavigationExtensions


internal abstract class BaseFragment<VB : ViewBinding>() : Fragment(), LifecycleObserver, BaseNavigator {

    private lateinit var _binding: ViewBinding
    abstract val bindingInflater: (LayoutInflater) -> VB

    @Suppress("UNCHECKED_CAST")
    protected val binding: VB
        get() = _binding as VB

    abstract fun setupUi(savedInstanceState: Bundle?)


    @CallSuper
    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        _binding = bindingInflater.invoke(layoutInflater)
        _binding.root.setViewTreeLifecycleOwner(this)
        return _binding.root
    }

    @CallSuper
    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        hideLoading()
        setupUi(savedInstanceState)
    }

    override fun handleAPIException(ex: Throwable) {
        (activity as? BaseActivity<*>)?.handleAPIException(ex)
    }

    override fun hideLoading() {
    }

    override fun showLoading() {
    }

    fun navigate(
        directions: Int,
        redirectFrom: String?,
        presentToUp: Boolean = false,
        extras: Bundle? = null
    ) {
        if (!isAdded) {
            return
        }

        runCatching {
            val navObjects = NavigationExtensions.prepareNavigationObjects(
                directions,
                redirectFrom, presentToUp,
                extras
            )
            findNavController().navigate(navObjects.newDirection, navObjects.navOptions)
        }
    }

    override fun showConnectionWarning(
        isInternetConnectionWarning: Boolean,
        errorCode: Int?,
        error: String?,
        onRetry: (() -> Unit)?
    ) {

    }
}