package gg.gamerewards.ui.customView

import android.app.AlertDialog
import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import gg.gamerewards.R
import gg.gamerewards.databinding.DialogPermissionsBinding
import gg.gamerewards.utils.PermissionManager
import gg.gamerewards.utils.setDialogWidthPercentageBasedOnScreenSize

class PermissionsDialog constructor(
    val ctx: Context,
    val permissionsDialogImpl: PermissionsDialogImpl
) : AlertDialog(ctx, R.style.FullScreenAlertDialog) {

    interface PermissionsDialogImpl {
        fun onClickedPermitUsageStatsPermission()

        fun onPermissionDismissed(dismiss: () -> Unit)
    }

    private var mBinding: DialogPermissionsBinding? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val inflater = context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        mBinding = DialogPermissionsBinding.inflate(inflater)
        mBinding?.let {
            it.cvContainer.setDialogWidthPercentageBasedOnScreenSize(ctx)
            setContentView(it.root)
        }

        setupUI()
    }

    /**
     * Sets type of toolbar and accordingly UI.
     */
    private fun setupUI() {
        mBinding?.let { mBinding ->
            mBinding.ivClose.setOnClickListener { dismiss() }
            mBinding.btnPermitUsageStats.setOnClickListener {
                permissionsDialogImpl.onClickedPermitUsageStatsPermission()
            }
        }

        onResume()
    }


    fun onResume() {
        if (PermissionManager.areRequiredPermissionsGranted(ctx)) {
            permissionsDialogImpl.onPermissionDismissed {
                dismiss()
            }
            return
        }

        mBinding?.apply {
            if (PermissionManager.isUsageStatsPermissionGranted(ctx)) {
                btnPermitUsageStats.isEnabled = false
                btnPermitUsageStats.setText(R.string.permission_dialog_permitted)
            } else {
                btnPermitUsageStats.isEnabled = true
                btnPermitUsageStats.setText(R.string.permission_dialog_permit)
            }
        }
    }
}