package gg.gamerewards.ui.fragments.gameDetail.checkPointsSeeAll

import android.os.Bundle
import android.view.LayoutInflater
import androidx.core.view.isVisible
import androidx.recyclerview.widget.LinearLayoutManager
import com.bumptech.glide.Glide
import com.bumptech.glide.load.resource.bitmap.CircleCrop
import gg.gamerewards.ViewModelProvider
import gg.gamerewards.databinding.FragmentCheckpointSeeAllBinding
import gg.gamerewards.ui.base.BasePermissionFragment
import gg.gamerewards.ui.fragments.gameDetail.BlockageType
import gg.gamerewards.ui.fragments.gameDetail.CheckPointAdapter
import gg.gamerewards.ui.fragments.gameDetail.CheckpointTimeBasedPermissionListener
import gg.gamerewards.utils.CircleBorderTransformation

/**
 * Created by Hasan Güler on 22.06.2023.
 */
internal class CheckPointsSeeAllFragment :
    BasePermissionFragment<FragmentCheckpointSeeAllBinding>(),
    CheckpointTimeBasedPermissionListener {

    override val bindingInflater: (LayoutInflater) -> FragmentCheckpointSeeAllBinding
        get() = FragmentCheckpointSeeAllBinding::inflate

    private val viewModel: CheckPointsSeeAllViewModel =
        ViewModelProvider.getInstance().provideCheckpointSeeAllViewModel()

    private var isPlaytimeHandledByOffer: Boolean? = null

    override fun setupUi(savedInstanceState: Bundle?) {
        viewModel.navigator = this
        viewModel.checkPoints.value = arguments?.getParcelableArrayList("checkPointList")
        isPlaytimeHandledByOffer = arguments?.getBoolean("isPlaytimeHandledByOffer")
        viewModel.currentCheckPoint.value =
            viewModel.checkPoints.value?.firstOrNull { !it.isCompleted }

        viewModel.currentCheckPoint.observe(this) { checkPoint ->
            with(binding) {
                this?.let {
                    currentCheckpointTitle.text = checkPoint?.title
                    tvCurrentCheckpointDescription.text = checkPoint?.subtitle
                    cvCurrentCheckpoint.isVisible = checkPoint != null
                    context?.let { ctx ->
                        Glide.with(ctx)
                            .load(checkPoint?.iconUrl)
                            .transform(CircleCrop(), CircleBorderTransformation())
                            .into(ivIcon)
                    }
                    progressBarCurrent.progress = checkPoint?.viewProgress ?: 0
                }
            }
        }

        viewModel.checkPoints.observe(this) {
            setupCheckPointRecyclerView()
        }
    }

    private fun setupCheckPointRecyclerView() {
        with(binding?.rvCheckpoints)
        {
            this?.let {
                val currentAdapter = adapter
                //Filter Blockage Type Hidden
                val currentList = ArrayList(viewModel.checkPoints.value?.flatMap { checkPoint ->
                    when (checkPoint.isBlocked) {
                        true -> if (checkPoint.blockageType != BlockageType.HIDDEN.toString()) listOf(
                            checkPoint
                        ) else emptyList()

                        else -> listOf(checkPoint)
                    }
                } ?: arrayListOf())
                if (currentAdapter is CheckPointAdapter)
                    currentAdapter.submitList(currentList)
                else {
                    val mAdapter = CheckPointAdapter(context,
                        isPlaytimeHandledByOffer,
                        this@CheckPointsSeeAllFragment,
                        onPermitAndEarnClicked = {
                            onClickedPermitUsageStatsPermission()
                        }).apply {
                        submitList(currentList)
                    }
//                mAdapter.listener = this@ShopFragment
                    adapter = mAdapter

                    val lManager = LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
                    layoutManager = lManager
                }
            }
        }
    }

    override fun requestPermissions() {
    }

    override fun onResume() {
        super.onResume()
        setupCheckPointRecyclerView()
    }
}