package gg.gamerewards.ui.fragments.games

import android.os.Bundle
import android.view.LayoutInflater
import android.widget.LinearLayout
import android.widget.Toast
import androidx.recyclerview.widget.LinearLayoutManager
import com.bumptech.glide.Glide
import com.google.android.material.bottomsheet.BottomSheetBehavior
import gg.gamerewards.ViewModelProvider
import gg.gamerewards.data.model.Profile
import gg.gamerewards.data.model.response.GamesFragmentOfferType
import gg.gamerewards.data.model.response.OfferGroup
import gg.gamerewards.databinding.FragmentGamesBinding
import gg.gamerewards.ui.activities.offerwallActivity.OfferwallActivity
import gg.gamerewards.ui.base.BaseFragment
import gg.gamerewards.utils.asInstance


/**
 * Created by Hasan Güler on 16.05.2023.
 */

internal class GamesFragment : BaseFragment<FragmentGamesBinding>(), GamesAdapterListener {


    override val bindingInflater: (LayoutInflater) -> FragmentGamesBinding
        get() = FragmentGamesBinding::inflate

    private var viewModel: GamesViewModel? = null

    private var bottomSheetBehavior: BottomSheetBehavior<LinearLayout>? = null

    override fun setupUi(savedInstanceState: Bundle?) {
        viewModel = ViewModelProvider.getInstance().provideGamesViewModel()
        viewModel?.navigator = this
        viewModel?.placementComponentList?.observe(this) {
            if(it != null){
                Glide.with(this)
                    .load(it.headerImageUrl)
                    .into(binding.ivHeaderLogo)
            }
            setupContentRecyclerView()
        }

        binding?.swipeRefreshLayout?.setOnRefreshListener {
            binding?.swipeRefreshLayout?.isRefreshing = false;
        }

        binding.btnClaim.setOnClickListener {
            Profile.profileData?.userKeyId?.let { userKeyId ->
                viewModel?.giveBonusCoinToUserKeyId(userKeyId, 500)
                Toast.makeText(context,"500 coin given to userkeyId : $userKeyId",Toast.LENGTH_LONG).show()
            }
        }
    }

    private fun setupContentRecyclerView() {
        binding.rvContent.apply {
            viewModel?.apply {
                val currentAdapter = adapter
                if (currentAdapter is GamesAdapter){
                    //if footer not exists in the list then add footer
                    if(placementComponentList.value?.offerGroups?.any { it.viewStyle == GamesFragmentOfferType.footer } == false){
                        placementComponentList.value?.offerGroups?.add(OfferGroup(GamesFragmentOfferType.footer,"", null,false,true))
                    }
                    currentAdapter.submitList(placementComponentList.value?.offerGroups)
                }
                else {
                    val mAdapter = GamesAdapter(context).apply {
                        //if footer not exists in the list then add footer
                        if(placementComponentList.value?.offerGroups?.any { it.viewStyle == GamesFragmentOfferType.footer } == false){
                            placementComponentList.value?.offerGroups?.add(OfferGroup(GamesFragmentOfferType.footer,"", null,false,true))
                        }

                        submitList(placementComponentList.value?.offerGroups)
                    }
                    mAdapter.listener = this@GamesFragment
                    adapter = mAdapter
                    val lManager = LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
                    layoutManager = lManager
                }
            }
        }
    }

    override fun onResume() {
        super.onResume()
        //viewModel?.getOfferwall()
        viewModel?.filterDashboardComponentList(
            requireContext(),
            viewModel?.placementComponentList?.value)
    }

    override fun onAction(action: String?, clickURL: String?, from: String?, fromTitle: String?) {
        activity?.asInstance(OfferwallActivity::class)
            ?.handleDeeplink(action, clickURL, from, fromTitle)
    }

    override fun onEventLogRequest(eventName: Any, parameters: Map<Any, Any?>?) {

    }
}