package gg.gamerewards.ui.fragments.games

import android.content.Context
import android.util.Log
import androidx.lifecycle.MutableLiveData
import gg.gamerewards.data.api.ApiRepository
import gg.gamerewards.data.model.response.Placement
import gg.gamerewards.ui.base.BaseNavigator
import gg.gamerewards.ui.base.BaseViewModel
import gg.gamerewards.utils.PermissionManager
import gg.gamerewards.utils.getIOScopeForAPICall
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * Created by Hasan Güler on 16.05.2023.
 */


internal class GamesViewModel(private val apiRepository: ApiRepository) :
    BaseViewModel<BaseNavigator>() {

    var placementComponentList: MutableLiveData<Placement?> =
        MutableLiveData(null)

    fun getPlacementDetailsByPlacementId(context: Context, placementId: String, onComplete: (() -> Unit)? = null) {
        navigator?.showLoading()
        getIOScopeForAPICall(handleAPIExceptions = false) {
            val response = apiRepository.getPlacementDetailsByPlacementId(placementId)
            withContext(Dispatchers.Main) {
                if (response.isSuccessful && response.body() != null) {
                    val tempPlacement = response.body()?.placement
                    filterDashboardComponentList(context, tempPlacement)
                    onComplete?.invoke()
                } else {
                    Log.e("getDashboardData", "error")
                }
                navigator?.hideLoading()
            }
        }
    }

    fun giveBonusCoinToUserKeyId(userKeyId: String, rewardAmount: Int , onComplete: (() -> Unit)? = null) {
        getIOScopeForAPICall(handleAPIExceptions = false) {
            apiRepository.giveBonusCoinToUserKeyId(userKeyId, rewardAmount)
        }
    }

    fun filterDashboardComponentList(context: Context, placement: Placement?){
        var tempPlacement = placement
        //Filter all offers that has grantPermission action. //first filter.
        if (PermissionManager.areRequiredPermissionsGranted(context)) {
            tempPlacement?.offerGroups?.forEach { offerGroup ->
                offerGroup.offers = offerGroup.offers?.filter { offer ->
                    !(offer.action?.contains("claim/grantPermission") ?: false)
                }?.let { ArrayList(it) }
            }
        }

        //Filter offers that have offers and (isActive == true) //second filter
        val filteredOfferGroupList = tempPlacement?.offerGroups?.filter { offerGroup ->
            (offerGroup.isActive == true)  && (offerGroup.offers?.isNotEmpty() ?: false)
        }?.let { ArrayList(it) }

        //offergroups changed to filteredList
        tempPlacement?.offerGroups = filteredOfferGroupList
        placementComponentList.value = tempPlacement
    }
}