package gg.gamerewards.ui.fragments.games.subAdapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import dagger.hilt.android.qualifiers.ApplicationContext
import gg.gamerewards.data.model.Profile
import gg.gamerewards.data.model.response.Offer
import gg.gamerewards.databinding.ItemSubMultiHorizontalAxisHorizontalCardBinding
import gg.gamerewards.databinding.ItemSubMultiHorizontalAxisVerticalCardBinding
import gg.gamerewards.ui.fragments.games.GamesAdapterListener
import gg.gamerewards.utils.PremiumOfferUIHelper
import gg.gamerewards.utils.RichieUtils
import gg.gamerewards.utils.dpToPx
import javax.inject.Inject


/**
 * Created by Hasan Güler on 31.05.2023.
 */
internal class HorizontalCardWithCardOfferLabelListAdapter @Inject constructor(
    @ApplicationContext val context: Context,
    private val isHorizontalCard: Boolean,
    private val isDoubleCard: Boolean = false,
    private var from: String?,
    private var fromTitle: String?
) :
    RecyclerView.Adapter<RecyclerView.ViewHolder>() {
    private var items: ArrayList<Offer> = arrayListOf()
    var listener: GamesAdapterListener? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        if (isHorizontalCard) {
            return ItemMultiHorizontalAxisHorizontalCardViewHolder(
                ItemSubMultiHorizontalAxisHorizontalCardBinding.inflate(
                    LayoutInflater.from(
                        parent.context
                    ), parent, false
                )
            )
        } else {
            return ItemMultiHorizontalAxisVerticalCardViewHolder(
                ItemSubMultiHorizontalAxisVerticalCardBinding.inflate(
                    LayoutInflater.from(
                        parent.context
                    ), parent, false
                )
            )
        }

    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        val currentItem = getCurrentItem(position)
        when (holder) {
            is ItemMultiHorizontalAxisHorizontalCardViewHolder -> holder.bind(currentItem, context, listener)
            is ItemMultiHorizontalAxisVerticalCardViewHolder -> holder.bind(currentItem, context, isDoubleCard, listener)
        }
    }

    private fun getCurrentItem(position: Int): Offer = items[position]

    override fun getItemCount(): Int = items.count()

    fun submitList(addedItems: ArrayList<Offer>?) {
        this.items.clear()
        if (addedItems != null) {
            this.items = ArrayList(addedItems)
        }

        notifyDataSetChanged()
    }

    inner class ItemMultiHorizontalAxisHorizontalCardViewHolder(val binding: ItemSubMultiHorizontalAxisHorizontalCardBinding) :
        RecyclerView.ViewHolder(binding.root) {

        fun bind(
            model: Offer,
            context: Context,
            listener: GamesAdapterListener?
        ) {
            try {
                Glide.with(context)
                    .load(model.horizontalCardImageUrl)
                    .into(binding.ivBackground)

                binding.cvCardLabel.isVisible = !model.cardLabel.isNullOrEmpty()
                binding.tvCardLabel.text = model.cardLabel
                binding.tvCardLabel.setTextColor(RichieUtils.parseColor("#${model.cardLabelTextColor}"))
                binding.llCardLabelContainer.setBackgroundColor(RichieUtils.parseColor("#${model.cardLabelBackgroundColor}"))
                Glide.with(context)
                    .load(model.cardLabelIconUrl)
                    .into(binding.ivCardLabelIcon)

                binding.layoutPremium.apply {
                    PremiumOfferUIHelper().setUIForPremiumOffer(context,false,model,clPremiumContainer,tvUnlockCoinAmount,flPremiumLock,llPremiumUnlocked,progressBar,premiumOfferLottieView)
                }

                val isPremiumCoinEnough =
                    (Profile.profileData?.totalEarnedCoins ?: 0) >= (model.premiumUnlockCoinAmount ?: 0)
                binding.root.setOnClickListener {
                    if (model.isPremiumOffer != true|| isPremiumCoinEnough) {
                        listener?.onAction("${model.action}/${model.isPremiumOffer}", model.clickUrl, from, fromTitle)
                    }
                }
            } catch (_: Exception) {
            }
        }
    }

    inner class ItemMultiHorizontalAxisVerticalCardViewHolder(val binding: ItemSubMultiHorizontalAxisVerticalCardBinding) :
        RecyclerView.ViewHolder(binding.root) {

        fun bind(
            model: Offer,
            context: Context,
            isDoubleCard: Boolean,
            listener: GamesAdapterListener?
        ) {
            try {
                Glide.with(context)
                    .load(model.verticalCardImageUrl)
                    .into(binding.ivBackground)

                if (isDoubleCard) {
                    binding.root.setPadding(0, context.dpToPx(4),0, context.dpToPx(4))
                }else {
                    binding.root.setPadding(0,0,0, 0)
                }

                binding.cvCardLabel.isVisible = !model.cardLabel.isNullOrEmpty()
                binding.tvCardLabel.text = model.cardLabel
                binding.tvCardLabel.setTextColor(RichieUtils.parseColor("#${model.cardLabelTextColor}"))
                binding.llCardLabelContainer.setBackgroundColor(RichieUtils.parseColor("#${model.cardLabelBackgroundColor}"))
                Glide.with(context)
                    .load(model.cardLabelIconUrl)
                    .into(binding.ivCardLabelIcon)

                binding.layoutPremium.apply {
                    PremiumOfferUIHelper().setUIForPremiumOffer(context,true,model,clPremiumContainer,tvUnlockCoinAmount,flPremiumLock,llPremiumUnlocked,progressBar,premiumOfferLottieView)
                }

                val isPremiumCoinEnough =
                    (Profile.profileData?.totalEarnedCoins ?: 0) >= (model.premiumUnlockCoinAmount ?: 0)
                binding.root.setOnClickListener {
                    if (model.isPremiumOffer != true || isPremiumCoinEnough)
                        listener?.onAction("${model.action}/${model.isPremiumOffer}", model.clickUrl, from, fromTitle)
                }
            } catch (_: Exception) {
            }
        }
    }
}
