package gg.gamerewards.ui.fragments.games.subAdapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import dagger.hilt.android.qualifiers.ApplicationContext
import gg.gamerewards.R
import gg.gamerewards.data.model.Profile
import gg.gamerewards.data.model.response.Offer
import gg.gamerewards.databinding.ItemSubMultiHorizontalAxisProgressCardTitleInsideBinding
import gg.gamerewards.databinding.ItemSubMultiHorizontalAxisProgressCardTitleOutsideBinding
import gg.gamerewards.ui.fragments.games.GamesAdapterListener
import gg.gamerewards.utils.RichieUtils
import javax.inject.Inject


/**
 * Created by Hasan Güler on 31.05.2023.
 */
internal class MultiHorizontalAxisProgressCardAdapter @Inject constructor(@ApplicationContext val context: Context, val isTitleInside: Boolean,val from : String?,val fromTitle : String?) :
    RecyclerView.Adapter<RecyclerView.ViewHolder>() {
    private var items: ArrayList<Offer> = arrayListOf()
    var listener: GamesAdapterListener? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        if (isTitleInside) {
            return ItemMultiHorizontalAxisProgressCardTitleInsideViewHolder(
                ItemSubMultiHorizontalAxisProgressCardTitleInsideBinding.inflate(
                    LayoutInflater.from(
                        parent.context
                    ), parent, false
                )
            )
        } else {
            return ItemMultiHorizontalAxisProgressCardTitleOutsideViewHolder(
                ItemSubMultiHorizontalAxisProgressCardTitleOutsideBinding.inflate(
                    LayoutInflater.from(
                        parent.context
                    ), parent, false
                )
            )
        }

    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        val currentItem = getCurrentItem(position)
        when (holder) {
            is ItemMultiHorizontalAxisProgressCardTitleInsideViewHolder -> holder.bind(currentItem, context, listener)
            is ItemMultiHorizontalAxisProgressCardTitleOutsideViewHolder -> holder.bind(currentItem, context, listener)
        }
    }

    private fun getCurrentItem(position: Int): Offer = items[position]

    override fun getItemCount(): Int = items.count()

    fun submitList(addedItems: ArrayList<Offer>?) {
        this.items.clear()
        if (addedItems != null) {
            this.items = ArrayList(addedItems)
        }

        notifyDataSetChanged()
    }

   inner class ItemMultiHorizontalAxisProgressCardTitleInsideViewHolder(val binding: ItemSubMultiHorizontalAxisProgressCardTitleInsideBinding) :
        RecyclerView.ViewHolder(binding.root) {

        fun bind(
            model: Offer,
            context: Context,
            listener: GamesAdapterListener?
        ) {
            try {
                Glide.with(context)
                    .load(model.verticalCardImageUrl)
                    .into(binding.ivBackground)

                binding.tvTitle.text = model.subtitle
                binding.tvTitle.setTextColor(RichieUtils.parseColor("#${model.titleTextColor}"))
                val coinAmount = model.cardLabel?.replace("+","")
                binding.tvCoinAmount.text = "+$coinAmount"
                binding.cvActionButton.setCardBackgroundColor(RichieUtils.parseColor("#${model.actionButtonBackgroundColor}"))

                binding.progressBar.progress = model.viewProgress

                val isPremiumCoinEnough =
                    (Profile.profileData?.totalEarnedCoins ?: 0) >= (model.premiumUnlockCoinAmount ?: 0)
                val isOfferPremium = (model.isPremiumOffer ?: false) && (!(model.isPremiumUnlocked ?: true) || !isPremiumCoinEnough)
                binding.llInfo.isVisible = !isOfferPremium
                binding.layoutPremium.apply {
                    progressBar.progress = model.premiumCoinViewProgress
                    tvUnlockCoinAmount.text = context.getString(R.string.premium_offer_unlock_text_horizontal,model.premiumUnlockCoinAmount.toString())
                    clPremiumContainer.isVisible = isOfferPremium
                    if (isOfferPremium){
                        premiumOfferLottieView.setAnimation(
                            if (isPremiumCoinEnough) R.raw.premium_offer_unlock_anim else R.raw.premium_offer_lock_anim)
                        premiumOfferLottieView.playAnimation()
                    }
                    isPremiumCoinEnough.apply {
                        flPremiumLock.isVisible = !this
                        llPremiumUnlocked.isVisible = this
                    }
                }
                binding.root.setOnClickListener {
                    if (model.isPremiumOffer != true || isPremiumCoinEnough) {
                        listener?.onAction("${model.action}/${model.isPremiumOffer}", model.clickUrl, from, fromTitle)
                    }
                }
            } catch (_: Exception) {
            }
        }
    }

    inner class ItemMultiHorizontalAxisProgressCardTitleOutsideViewHolder(val binding: ItemSubMultiHorizontalAxisProgressCardTitleOutsideBinding) :
        RecyclerView.ViewHolder(binding.root) {

        fun bind(
            model: Offer,
            context: Context,
            listener: GamesAdapterListener?
        ) {
            try {
                Glide.with(context)
                    .load(model.horizontalCardImageUrl)
                    .into(binding.ivBackground)

                binding.tvTitle.text = model.title
                binding.tvTitle.setTextColor(RichieUtils.parseColor("#${model.titleTextColor}"))
                binding.tvActionButton.text = model.actionButtonTitle
                binding.tvActionButton.setTextColor(RichieUtils.parseColor("#${model.actionButtonTextColor}"))
                binding.cvActionButton.setCardBackgroundColor(RichieUtils.parseColor("#${model.actionButtonBackgroundColor}"))

                binding.progressBar.progress = model.viewProgress

                val isPremiumCoinEnough =
                    (Profile.profileData?.totalEarnedCoins ?: 0) >= (model.premiumUnlockCoinAmount ?: 0)
                val isOfferPremium = (model.isPremiumOffer ?: false) && (!(model.isPremiumUnlocked ?: true) || !isPremiumCoinEnough)
                binding.cvLayoutPremiumContainer.isVisible = isOfferPremium
                binding.layoutPremium.apply {
                    if (isOfferPremium){
                        premiumOfferLottieView.setAnimation(
                            if (isPremiumCoinEnough) R.raw.premium_offer_unlock_anim else R.raw.premium_offer_lock_anim)
                        premiumOfferLottieView.playAnimation()
                    }
                    progressBar.progress = model.premiumCoinViewProgress
                    tvUnlockCoinAmount.text = context.getString(R.string.premium_offer_unlock_text_horizontal,model.premiumUnlockCoinAmount.toString())
                    isPremiumCoinEnough.apply {
                        flPremiumLock.isVisible = !this
                        llPremiumUnlocked.isVisible = this
                    }
                }
                binding.root.setOnClickListener {
                    if (model.isPremiumOffer != true || isPremiumCoinEnough)
                        listener?.onAction("${model.action}/${model.isPremiumOffer}", model.clickUrl, from, fromTitle)
                }
            } catch (_: Exception) {
            }
        }
    }
}
