package gg.gamerewards.ui.fragments.games.subAdapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import dagger.hilt.android.qualifiers.ApplicationContext
import gg.gamerewards.data.model.Profile
import gg.gamerewards.data.model.response.Offer
import gg.gamerewards.databinding.ItemComponentSliderCardBinding
import gg.gamerewards.ui.fragments.games.GamesAdapterListener
import gg.gamerewards.utils.PremiumOfferUIHelper
import gg.gamerewards.utils.RichieUtils
import javax.inject.Inject

internal class MultiHorizontalViewSliderAdapter @Inject constructor(
    @ApplicationContext val context: Context,
    private var from: String?,
    private var fromTitle: String?) :
    RecyclerView.Adapter<RecyclerView.ViewHolder>() {
    private var items: ArrayList<Offer> = arrayListOf()
    var listener: GamesAdapterListener? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return MultiSlimHorizontalAxisSliderHolder(
            ItemComponentSliderCardBinding.inflate(
                LayoutInflater.from(
                    parent.context
                ), parent, false
            )
        )
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        val currentItem = getCurrentItem(position)
        when (holder) {
            is MultiSlimHorizontalAxisSliderHolder -> holder.bind(currentItem, context, listener)
        }
    }

    private fun getCurrentItem(position: Int): Offer = items[position]

    override fun getItemViewType(position: Int): Int {
        return 0
    }

    override fun getItemCount(): Int  =  items.count()

    fun submitList(addedItems: ArrayList<Offer>?) {
        this.items.clear()
        if (addedItems != null) {
            this.items = ArrayList(addedItems)
        }

        notifyDataSetChanged()
    }

    inner class MultiSlimHorizontalAxisSliderHolder(val binding: ItemComponentSliderCardBinding) :
        RecyclerView.ViewHolder(binding.root) {

        fun bind(
            offer: Offer,
            context: Context,
            listener: GamesAdapterListener?
        ) {
            try {

                binding.tvCardLabel.text = offer.cardLabel
                    Glide.with(context)
                        .load(offer.horizontalCardImageUrl)
                        .into(binding.ivBackground)

                    binding.cvCardLabel.isVisible = !offer.cardLabel.isNullOrEmpty()
                    binding.llCardLabelContainer.setBackgroundColor(RichieUtils.parseColor("#${offer.cardLabelBackgroundColor}"))
                    Glide.with(context)
                        .load(offer.cardLabelIconUrl)
                        .into(binding.ivCardLabelIcon)

                binding.layoutPremium.apply {
                    PremiumOfferUIHelper().setUIForPremiumOffer(context,false,offer,clPremiumContainer,tvUnlockCoinAmount,flPremiumLock,llPremiumUnlocked,progressBar,premiumOfferLottieView)
                }

                val isPremiumCoinEnough =
                    (Profile.profileData?.totalEarnedCoins ?: 0) >= (offer.premiumUnlockCoinAmount ?: 0)
                binding.root.setOnClickListener {
                    if (offer.isPremiumOffer != true || isPremiumCoinEnough)
                        listener?.onAction("${offer.action}/${offer.isPremiumOffer}", offer.clickUrl, from, fromTitle)
                }

            } catch (_: Exception) {}
        }
    }
}
