package gg.gamerewards.utils

import android.graphics.Bitmap
import android.graphics.BitmapShader
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.graphics.Shader
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation
import java.security.MessageDigest
import kotlin.math.min

class CircleBorderTransformation() : BitmapTransformation() {

    private val borderSize = 4 // Border size in pixels

    override fun transform(
        pool: BitmapPool,
        toTransform: Bitmap,
        outWidth: Int,
        outHeight: Int
    ): Bitmap {
        val radius = (min(outWidth, outHeight) / 2).toFloat()

        val bitmap = pool.get(outWidth, outHeight, Bitmap.Config.ARGB_8888)
        val canvas = Canvas(bitmap)

        // Draw the circular image
        val paint = Paint()
        paint.isAntiAlias = true
        val shader = BitmapShader(toTransform, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP)
        paint.shader = shader
        canvas.drawCircle(outWidth / 2f, outHeight / 2f, radius - borderSize, paint)

        // Draw the border
        val borderPaint = Paint()
        borderPaint.color = Color.WHITE // Border color
        borderPaint.isAntiAlias = true
        borderPaint.style = Paint.Style.STROKE
        borderPaint.strokeWidth = borderSize.toFloat()
        canvas.drawCircle(outWidth / 2f, outHeight / 2f, radius - borderSize / 2f, borderPaint)

        return bitmap
    }

    override fun updateDiskCacheKey(messageDigest: MessageDigest) {
        // Implementation not needed for now
    }
}
