/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.freight.schema;

import global.maplink.MapLinkServiceRequest;
import global.maplink.env.Environment;
import global.maplink.freight.schema.AdditionalCosts;
import global.maplink.freight.schema.FreightCalculationResponse;
import global.maplink.freight.schema.GoodsType;
import global.maplink.freight.schema.OperationType;
import global.maplink.freight.schema.exception.FreightErrorType;
import global.maplink.http.Response;
import global.maplink.http.request.Request;
import global.maplink.http.request.RequestBody;
import global.maplink.json.JsonMapper;
import global.maplink.validations.ValidationViolation;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;

public class FreightCalculationRequest
implements MapLinkServiceRequest<FreightCalculationResponse> {
    public static final String PATH = "freight/v1/calculations";
    private final Set<OperationType> operationType;
    private final Set<GoodsType> goodsType;
    private final Set<Integer> axis;
    private final List<AdditionalCosts> otherCosts;
    private final BigDecimal distance;
    private final LocalDate date;
    private final boolean roundTrip;
    private final boolean backEmpty;

    public Request asHttpRequest(Environment environment, JsonMapper mapper) {
        return Request.post((URL)environment.withService(PATH), (RequestBody)RequestBody.Json.of((Object)this, (JsonMapper)mapper));
    }

    public Function<Response, FreightCalculationResponse> getResponseParser(JsonMapper mapper) {
        return r -> (FreightCalculationResponse)r.parseBodyObject(mapper, FreightCalculationResponse.class);
    }

    public List<ValidationViolation> validate() {
        ArrayList<ValidationViolation> errors = new ArrayList<ValidationViolation>();
        if (this.date == null) {
            errors.add(FreightErrorType.DATE_FIELD_EMPTY);
        }
        if (this.operationType == null || this.operationType.isEmpty()) {
            errors.add(FreightErrorType.OPERATION_TYPE_FIELD_EMPTY);
        }
        if (this.goodsType == null || this.goodsType.isEmpty()) {
            errors.add(FreightErrorType.GOODS_TYPE_FIELD_EMPTY);
        }
        if (this.axis == null || this.axis.isEmpty()) {
            errors.add(FreightErrorType.AXIS_FIELD_EMPTY);
        }
        return errors;
    }

    @Generated
    public static FreightCalculationRequestBuilder builder() {
        return new FreightCalculationRequestBuilder();
    }

    @Generated
    public Set<OperationType> getOperationType() {
        return this.operationType;
    }

    @Generated
    public Set<GoodsType> getGoodsType() {
        return this.goodsType;
    }

    @Generated
    public Set<Integer> getAxis() {
        return this.axis;
    }

    @Generated
    public List<AdditionalCosts> getOtherCosts() {
        return this.otherCosts;
    }

    @Generated
    public BigDecimal getDistance() {
        return this.distance;
    }

    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Generated
    public boolean isRoundTrip() {
        return this.roundTrip;
    }

    @Generated
    public boolean isBackEmpty() {
        return this.backEmpty;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FreightCalculationRequest)) {
            return false;
        }
        FreightCalculationRequest other = (FreightCalculationRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRoundTrip() != other.isRoundTrip()) {
            return false;
        }
        if (this.isBackEmpty() != other.isBackEmpty()) {
            return false;
        }
        Set<OperationType> this$operationType = this.getOperationType();
        Set<OperationType> other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)this$operationType).equals(other$operationType)) {
            return false;
        }
        Set<GoodsType> this$goodsType = this.getGoodsType();
        Set<GoodsType> other$goodsType = other.getGoodsType();
        if (this$goodsType == null ? other$goodsType != null : !((Object)this$goodsType).equals(other$goodsType)) {
            return false;
        }
        Set<Integer> this$axis = this.getAxis();
        Set<Integer> other$axis = other.getAxis();
        if (this$axis == null ? other$axis != null : !((Object)this$axis).equals(other$axis)) {
            return false;
        }
        List<AdditionalCosts> this$otherCosts = this.getOtherCosts();
        List<AdditionalCosts> other$otherCosts = other.getOtherCosts();
        if (this$otherCosts == null ? other$otherCosts != null : !((Object)this$otherCosts).equals(other$otherCosts)) {
            return false;
        }
        BigDecimal this$distance = this.getDistance();
        BigDecimal other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FreightCalculationRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRoundTrip() ? 79 : 97);
        result = result * 59 + (this.isBackEmpty() ? 79 : 97);
        Set<OperationType> $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)$operationType).hashCode());
        Set<GoodsType> $goodsType = this.getGoodsType();
        result = result * 59 + ($goodsType == null ? 43 : ((Object)$goodsType).hashCode());
        Set<Integer> $axis = this.getAxis();
        result = result * 59 + ($axis == null ? 43 : ((Object)$axis).hashCode());
        List<AdditionalCosts> $otherCosts = this.getOtherCosts();
        result = result * 59 + ($otherCosts == null ? 43 : ((Object)$otherCosts).hashCode());
        BigDecimal $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FreightCalculationRequest(operationType=" + this.getOperationType() + ", goodsType=" + this.getGoodsType() + ", axis=" + this.getAxis() + ", otherCosts=" + this.getOtherCosts() + ", distance=" + this.getDistance() + ", date=" + this.getDate() + ", roundTrip=" + this.isRoundTrip() + ", backEmpty=" + this.isBackEmpty() + ")";
    }

    @Generated
    private FreightCalculationRequest(Set<OperationType> operationType, Set<GoodsType> goodsType, Set<Integer> axis, List<AdditionalCosts> otherCosts, BigDecimal distance, LocalDate date, boolean roundTrip, boolean backEmpty) {
        this.operationType = operationType;
        this.goodsType = goodsType;
        this.axis = axis;
        this.otherCosts = otherCosts;
        this.distance = distance;
        this.date = date;
        this.roundTrip = roundTrip;
        this.backEmpty = backEmpty;
    }

    @Generated
    public static FreightCalculationRequest of(Set<OperationType> operationType, Set<GoodsType> goodsType, Set<Integer> axis, List<AdditionalCosts> otherCosts, BigDecimal distance, LocalDate date, boolean roundTrip, boolean backEmpty) {
        return new FreightCalculationRequest(operationType, goodsType, axis, otherCosts, distance, date, roundTrip, backEmpty);
    }

    @Generated
    private FreightCalculationRequest() {
        this.operationType = null;
        this.goodsType = null;
        this.axis = null;
        this.otherCosts = null;
        this.distance = null;
        this.date = null;
        this.roundTrip = false;
        this.backEmpty = false;
    }

    @Generated
    public static class FreightCalculationRequestBuilder {
        @Generated
        private Set<OperationType> operationType;
        @Generated
        private Set<GoodsType> goodsType;
        @Generated
        private Set<Integer> axis;
        @Generated
        private List<AdditionalCosts> otherCosts;
        @Generated
        private BigDecimal distance;
        @Generated
        private LocalDate date;
        @Generated
        private boolean roundTrip;
        @Generated
        private boolean backEmpty;

        @Generated
        FreightCalculationRequestBuilder() {
        }

        @Generated
        public FreightCalculationRequestBuilder operationType(Set<OperationType> operationType) {
            this.operationType = operationType;
            return this;
        }

        @Generated
        public FreightCalculationRequestBuilder goodsType(Set<GoodsType> goodsType) {
            this.goodsType = goodsType;
            return this;
        }

        @Generated
        public FreightCalculationRequestBuilder axis(Set<Integer> axis) {
            this.axis = axis;
            return this;
        }

        @Generated
        public FreightCalculationRequestBuilder otherCosts(List<AdditionalCosts> otherCosts) {
            this.otherCosts = otherCosts;
            return this;
        }

        @Generated
        public FreightCalculationRequestBuilder distance(BigDecimal distance) {
            this.distance = distance;
            return this;
        }

        @Generated
        public FreightCalculationRequestBuilder date(LocalDate date) {
            this.date = date;
            return this;
        }

        @Generated
        public FreightCalculationRequestBuilder roundTrip(boolean roundTrip) {
            this.roundTrip = roundTrip;
            return this;
        }

        @Generated
        public FreightCalculationRequestBuilder backEmpty(boolean backEmpty) {
            this.backEmpty = backEmpty;
            return this;
        }

        @Generated
        public FreightCalculationRequest build() {
            return new FreightCalculationRequest(this.operationType, this.goodsType, this.axis, this.otherCosts, this.distance, this.date, this.roundTrip, this.backEmpty);
        }

        @Generated
        public String toString() {
            return "FreightCalculationRequest.FreightCalculationRequestBuilder(operationType=" + this.operationType + ", goodsType=" + this.goodsType + ", axis=" + this.axis + ", otherCosts=" + this.otherCosts + ", distance=" + this.distance + ", date=" + this.date + ", roundTrip=" + this.roundTrip + ", backEmpty=" + this.backEmpty + ")";
        }
    }
}

